/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.util.CollectionUtils;

public final class OAuth2AccessTokenResponse {
    private OAuth2AccessToken accessToken;
    private Map<String, Object> additionalParameters;

    private OAuth2AccessTokenResponse() {
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public static Builder withToken(String tokenValue) {
        return new Builder(tokenValue);
    }

    public static class Builder {
        private String tokenValue;
        private OAuth2AccessToken.TokenType tokenType;
        private long expiresIn;
        private Set<String> scopes;
        private Map<String, Object> additionalParameters;

        private Builder(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        public Builder tokenType(OAuth2AccessToken.TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder expiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder additionalParameters(Map<String, Object> additionalParameters) {
            this.additionalParameters = additionalParameters;
            return this;
        }

        public OAuth2AccessTokenResponse build() {
            Instant issuedAt = Instant.now();
            Instant expiresAt = this.expiresIn > 0L ? issuedAt.plusSeconds(this.expiresIn) : issuedAt.plusSeconds(1L);
            OAuth2AccessTokenResponse accessTokenResponse = new OAuth2AccessTokenResponse();
            accessTokenResponse.accessToken = new OAuth2AccessToken(this.tokenType, this.tokenValue, issuedAt, expiresAt, this.scopes);
            accessTokenResponse.additionalParameters = Collections.unmodifiableMap(CollectionUtils.isEmpty(this.additionalParameters) ? Collections.emptyMap() : this.additionalParameters);
            return accessTokenResponse;
        }
    }
}

