/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public interface ClaimAccessor {
    public Map<String, Object> getClaims();

    default public Boolean containsClaim(String claim) {
        Assert.notNull((Object)claim, (String)"claim cannot be null");
        return this.getClaims().containsKey(claim);
    }

    default public String getClaimAsString(String claim) {
        return this.containsClaim(claim) != false ? this.getClaims().get(claim).toString() : null;
    }

    default public Boolean getClaimAsBoolean(String claim) {
        return this.containsClaim(claim) != false ? Boolean.valueOf(this.getClaimAsString(claim)) : null;
    }

    default public Instant getClaimAsInstant(String claim) {
        if (!this.containsClaim(claim).booleanValue()) {
            return null;
        }
        Object claimValue = this.getClaims().get(claim);
        if (Long.class.isAssignableFrom(claimValue.getClass())) {
            return Instant.ofEpochSecond((Long)claimValue);
        }
        if (Date.class.isAssignableFrom(claimValue.getClass())) {
            return ((Date)claimValue).toInstant();
        }
        if (Instant.class.isAssignableFrom(claimValue.getClass())) {
            return (Instant)claimValue;
        }
        throw new IllegalArgumentException("Unable to convert claim '" + claim + "' of type '" + claimValue.getClass() + "' to Instant.");
    }

    default public URL getClaimAsURL(String claim) {
        if (!this.containsClaim(claim).booleanValue()) {
            return null;
        }
        try {
            return new URL(this.getClaimAsString(claim));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Unable to convert claim '" + claim + "' to URL: " + ex.getMessage(), ex);
        }
    }

    default public Map<String, Object> getClaimAsMap(String claim) {
        if (!this.containsClaim(claim).booleanValue() || !Map.class.isAssignableFrom(this.getClaims().get(claim).getClass())) {
            return null;
        }
        HashMap<String, Object> claimValues = new HashMap<String, Object>();
        ((Map)this.getClaims().get(claim)).forEach((k, v) -> claimValues.put(k.toString(), v));
        return claimValues;
    }

    default public List<String> getClaimAsStringList(String claim) {
        if (!this.containsClaim(claim).booleanValue() || !List.class.isAssignableFrom(this.getClaims().get(claim).getClass())) {
            return null;
        }
        ArrayList<String> claimValues = new ArrayList<String>();
        ((List)this.getClaims().get(claim)).forEach(e -> claimValues.add(e.toString()));
        return claimValues;
    }
}

