/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public final class WebClientReactivePasswordTokenResponseClient
implements ReactiveOAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> {
    private static final String INVALID_TOKEN_RESPONSE_ERROR_CODE = "invalid_token_response";
    private WebClient webClient = WebClient.builder().build();

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(OAuth2PasswordGrantRequest passwordGrantRequest) {
        Assert.notNull((Object)passwordGrantRequest, (String)"passwordGrantRequest cannot be null");
        return Mono.defer(() -> {
            ClientRegistration clientRegistration = passwordGrantRequest.getClientRegistration();
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(clientRegistration.getProviderDetails().getTokenUri(), new Object[0])).headers(WebClientReactivePasswordTokenResponseClient.tokenRequestHeaders(clientRegistration))).body(WebClientReactivePasswordTokenResponseClient.tokenRequestBody(passwordGrantRequest)).exchange().flatMap(response -> {
                HttpStatus status = HttpStatus.resolve((int)response.rawStatusCode());
                if (status == null || !status.is2xxSuccessful()) {
                    OAuth2Error oauth2Error = new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, "An error occurred while attempting to retrieve the OAuth 2.0 Access Token Response: HTTP Status Code " + response.rawStatusCode(), null);
                    return response.bodyToMono(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)new OAuth2AuthorizationException(oauth2Error)));
                }
                return (Mono)response.body(OAuth2BodyExtractors.oauth2AccessTokenResponse());
            }).map(tokenResponse -> {
                if (CollectionUtils.isEmpty((Collection)tokenResponse.getAccessToken().getScopes())) {
                    tokenResponse = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)tokenResponse).scopes(passwordGrantRequest.getClientRegistration().getScopes()).build();
                }
                return tokenResponse;
            });
        });
    }

    private static Consumer<HttpHeaders> tokenRequestHeaders(ClientRegistration clientRegistration) {
        return headers -> {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            if (ClientAuthenticationMethod.BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
                headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret());
            }
        };
    }

    private static BodyInserters.FormInserter<String> tokenRequestBody(OAuth2PasswordGrantRequest passwordGrantRequest) {
        ClientRegistration clientRegistration = passwordGrantRequest.getClientRegistration();
        BodyInserters.FormInserter body = BodyInserters.fromFormData((String)"grant_type", (String)passwordGrantRequest.getGrantType().getValue());
        body.with("username", (Object)passwordGrantRequest.getUsername());
        body.with("password", (Object)passwordGrantRequest.getPassword());
        if (!CollectionUtils.isEmpty(passwordGrantRequest.getClientRegistration().getScopes())) {
            body.with("scope", (Object)StringUtils.collectionToDelimitedString(passwordGrantRequest.getClientRegistration().getScopes(), (String)" "));
        }
        if (ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_id", (Object)clientRegistration.getClientId());
            body.with("client_secret", (Object)clientRegistration.getClientSecret());
        }
        return body;
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }
}

