/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class WebClientReactiveAuthorizationCodeTokenResponseClient
implements ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> {
    private WebClient webClient = WebClient.builder().build();

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(OAuth2AuthorizationCodeGrantRequest authorizationGrantRequest) {
        return Mono.defer(() -> {
            ClientRegistration clientRegistration = authorizationGrantRequest.getClientRegistration();
            OAuth2AuthorizationExchange authorizationExchange = authorizationGrantRequest.getAuthorizationExchange();
            String tokenUri = clientRegistration.getProviderDetails().getTokenUri();
            BodyInserters.FormInserter<String> body = WebClientReactiveAuthorizationCodeTokenResponseClient.body(authorizationExchange);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(tokenUri, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).headers(headers -> headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret()))).body(body).exchange().flatMap(response -> (Mono)response.body(OAuth2BodyExtractors.oauth2AccessTokenResponse())).map(response -> {
                if (response.getAccessToken().getScopes().isEmpty()) {
                    response = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)response).scopes(authorizationExchange.getAuthorizationRequest().getScopes()).build();
                }
                return response;
            });
        });
    }

    private static BodyInserters.FormInserter<String> body(OAuth2AuthorizationExchange authorizationExchange) {
        OAuth2AuthorizationResponse authorizationResponse = authorizationExchange.getAuthorizationResponse();
        String redirectUri = authorizationExchange.getAuthorizationRequest().getRedirectUri();
        BodyInserters.FormInserter body = BodyInserters.fromFormData((String)"grant_type", (String)AuthorizationGrantType.AUTHORIZATION_CODE.getValue()).with("code", (Object)authorizationResponse.getCode());
        if (redirectUri != null) {
            body.with("redirect_uri", (Object)redirectUri);
        }
        return body;
    }
}

