/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client;

import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.OAuth2AuthorizedClientResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ServerOAuth2AuthorizedClientExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final String OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME = OAuth2AuthorizedClient.class.getName();
    private static final String CLIENT_REGISTRATION_ID_ATTR_NAME = OAuth2AuthorizedClient.class.getName().concat(".CLIENT_REGISTRATION_ID");
    private static final String SERVER_WEB_EXCHANGE_ATTR_NAME = ServerWebExchange.class.getName();
    private static final AnonymousAuthenticationToken ANONYMOUS_USER_TOKEN = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
    private Clock clock = Clock.systemUTC();
    private Duration accessTokenExpiresSkew = Duration.ofMinutes(1L);
    private ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
    private final OAuth2AuthorizedClientResolver authorizedClientResolver;

    public ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        this.authorizedClientRepository = authorizedClientRepository;
        this.authorizedClientResolver = new OAuth2AuthorizedClientResolver(clientRegistrationRepository, authorizedClientRepository);
    }

    public static Consumer<Map<String, Object>> oauth2AuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return attributes -> attributes.put(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME, authorizedClient);
    }

    private static OAuth2AuthorizedClient oauth2AuthorizedClient(ClientRequest request) {
        return (OAuth2AuthorizedClient)request.attributes().get(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> serverWebExchange(ServerWebExchange serverWebExchange) {
        return attributes -> attributes.put(SERVER_WEB_EXCHANGE_ATTR_NAME, serverWebExchange);
    }

    private static ServerWebExchange serverWebExchange(ClientRequest request) {
        return (ServerWebExchange)request.attributes().get(SERVER_WEB_EXCHANGE_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        return attributes -> attributes.put(CLIENT_REGISTRATION_ID_ATTR_NAME, clientRegistrationId);
    }

    private static String clientRegistrationId(ClientRequest request) {
        OAuth2AuthorizedClient authorizedClient = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        if (authorizedClient != null) {
            return authorizedClient.getClientRegistration().getRegistrationId();
        }
        return (String)request.attributes().get(CLIENT_REGISTRATION_ID_ATTR_NAME);
    }

    public void setDefaultOAuth2AuthorizedClient(boolean defaultOAuth2AuthorizedClient) {
        this.authorizedClientResolver.setDefaultOAuth2AuthorizedClient(defaultOAuth2AuthorizedClient);
    }

    public void setDefaultClientRegistrationId(String clientRegistrationId) {
        this.authorizedClientResolver.setDefaultClientRegistrationId(clientRegistrationId);
    }

    public void setClientCredentialsTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        this.authorizedClientResolver.setClientCredentialsTokenResponseClient(clientCredentialsTokenResponseClient);
    }

    public void setAccessTokenExpiresSkew(Duration accessTokenExpiresSkew) {
        Assert.notNull((Object)accessTokenExpiresSkew, (String)"accessTokenExpiresSkew cannot be null");
        this.accessTokenExpiresSkew = accessTokenExpiresSkew;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.authorizedClient(request, next).map(authorizedClient -> this.bearer(request, (OAuth2AuthorizedClient)authorizedClient)).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0)).switchIfEmpty(next.exchange(request));
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(ClientRequest request, ExchangeFunction next) {
        OAuth2AuthorizedClient authorizedClientFromAttrs = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        return Mono.justOrEmpty((Object)authorizedClientFromAttrs).switchIfEmpty(Mono.defer(() -> this.loadAuthorizedClient(request))).flatMap(authorizedClient -> this.refreshIfNecessary(request, next, (OAuth2AuthorizedClient)authorizedClient));
    }

    private Mono<OAuth2AuthorizedClient> loadAuthorizedClient(ClientRequest request) {
        return this.createRequest(request).flatMap(r -> this.authorizedClientResolver.loadAuthorizedClient((OAuth2AuthorizedClientResolver.Request)r));
    }

    private Mono<OAuth2AuthorizedClientResolver.Request> createRequest(ClientRequest request) {
        String clientRegistrationId = ServerOAuth2AuthorizedClientExchangeFilterFunction.clientRegistrationId(request);
        Authentication authentication = null;
        ServerWebExchange exchange = ServerOAuth2AuthorizedClientExchangeFilterFunction.serverWebExchange(request);
        return this.authorizedClientResolver.createDefaultedRequest(clientRegistrationId, authentication, exchange);
    }

    private Mono<OAuth2AuthorizedClient> refreshIfNecessary(ClientRequest request, ExchangeFunction next, OAuth2AuthorizedClient authorizedClient) {
        if (this.shouldRefresh(authorizedClient)) {
            return this.createRequest(request).flatMap(r -> this.refreshAuthorizedClient(next, authorizedClient, (OAuth2AuthorizedClientResolver.Request)r));
        }
        return Mono.just((Object)authorizedClient);
    }

    private Mono<OAuth2AuthorizedClient> refreshAuthorizedClient(ExchangeFunction next, OAuth2AuthorizedClient authorizedClient, OAuth2AuthorizedClientResolver.Request r) {
        ServerWebExchange exchange = r.getExchange();
        Authentication authentication = r.getAuthentication();
        ClientRegistration clientRegistration = authorizedClient.getClientRegistration();
        String tokenUri = clientRegistration.getProviderDetails().getTokenUri();
        ClientRequest refreshRequest = ClientRequest.create((HttpMethod)HttpMethod.POST, (URI)URI.create(tokenUri)).header("Accept", new String[]{"application/json"}).headers(headers -> headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret())).body(ServerOAuth2AuthorizedClientExchangeFilterFunction.refreshTokenBody(authorizedClient.getRefreshToken().getTokenValue())).build();
        return next.exchange(refreshRequest).flatMap(refreshResponse -> (Mono)refreshResponse.body(OAuth2BodyExtractors.oauth2AccessTokenResponse())).map(accessTokenResponse -> {
            OAuth2RefreshToken refreshToken = Optional.ofNullable(accessTokenResponse.getRefreshToken()).orElse(authorizedClient.getRefreshToken());
            return new OAuth2AuthorizedClient(authorizedClient.getClientRegistration(), authorizedClient.getPrincipalName(), accessTokenResponse.getAccessToken(), refreshToken);
        }).flatMap(result -> this.authorizedClientRepository.saveAuthorizedClient((OAuth2AuthorizedClient)result, authentication, exchange).thenReturn(result));
    }

    private boolean shouldRefresh(OAuth2AuthorizedClient authorizedClient) {
        Instant expiresAt;
        if (this.authorizedClientRepository == null) {
            return false;
        }
        OAuth2RefreshToken refreshToken = authorizedClient.getRefreshToken();
        if (refreshToken == null) {
            return false;
        }
        Instant now = this.clock.instant();
        return now.isAfter((expiresAt = authorizedClient.getAccessToken().getExpiresAt()).minus(this.accessTokenExpiresSkew));
    }

    private ClientRequest bearer(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(authorizedClient.getAccessToken().getTokenValue())).build();
    }

    private static BodyInserters.FormInserter<String> refreshTokenBody(String refreshToken) {
        return BodyInserters.fromFormData((String)"grant_type", (String)AuthorizationGrantType.REFRESH_TOKEN.getValue()).with("refresh_token", (Object)refreshToken);
    }
}

