/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.http.converter.OidcUserInfoHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationToken;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class OidcUserInfoEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OIDC_USER_INFO_ENDPOINT_URI = "/userinfo";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher userInfoEndpointMatcher;
    private final HttpMessageConverter<OidcUserInfo> userInfoHttpMessageConverter = new OidcUserInfoHttpMessageConverter();
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();

    public OidcUserInfoEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_OIDC_USER_INFO_ENDPOINT_URI);
    }

    public OidcUserInfoEndpointFilter(AuthenticationManager authenticationManager, String userInfoEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)userInfoEndpointUri, (String)"userInfoEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.userInfoEndpointMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(userInfoEndpointUri, HttpMethod.GET.name()), new AntPathRequestMatcher(userInfoEndpointUri, HttpMethod.POST.name())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.userInfoEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication principal = SecurityContextHolder.getContext().getAuthentication();
            OidcUserInfoAuthenticationToken userInfoAuthentication = new OidcUserInfoAuthenticationToken(principal);
            OidcUserInfoAuthenticationToken userInfoAuthenticationResult = (OidcUserInfoAuthenticationToken)this.authenticationManager.authenticate((Authentication)userInfoAuthentication);
            this.sendUserInfoResponse(response, userInfoAuthenticationResult.getUserInfo());
        }
        catch (OAuth2AuthenticationException ex) {
            this.sendErrorResponse(response, ex.getError());
        }
        catch (Exception ex) {
            OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Connect 1.0 UserInfo Error: " + ex.getMessage(), "https://openid.net/specs/openid-connect-core-1_0.html#UserInfoError");
            this.sendErrorResponse(response, error);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private void sendUserInfoResponse(HttpServletResponse response, OidcUserInfo userInfo) throws IOException {
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.userInfoHttpMessageConverter.write((Object)userInfo, null, (HttpOutputMessage)httpResponse);
    }

    private void sendErrorResponse(HttpServletResponse response, OAuth2Error error) throws IOException {
        HttpStatus httpStatus = HttpStatus.BAD_REQUEST;
        if (error.getErrorCode().equals("invalid_token")) {
            httpStatus = HttpStatus.UNAUTHORIZED;
        } else if (error.getErrorCode().equals("insufficient_scope")) {
            httpStatus = HttpStatus.FORBIDDEN;
        }
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(httpStatus);
        this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
    }
}

