/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ClientAuthenticationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenIntrospectionEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenRevocationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcConfigurer;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.web.NimbusJwkSetEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationServerMetadataEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.ProviderContextFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OAuth2AuthorizationServerConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OAuth2AuthorizationServerConfigurer<B>, B> {
    private final Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = this.createConfigurers();
    private RequestMatcher jwkSetEndpointMatcher;
    private RequestMatcher authorizationServerMetadataEndpointMatcher;
    private final RequestMatcher endpointsMatcher = request -> this.getRequestMatcher(OAuth2AuthorizationEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OAuth2TokenEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OAuth2TokenIntrospectionEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OAuth2TokenRevocationEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OidcConfigurer.class).matches(request) || this.jwkSetEndpointMatcher.matches(request) || this.authorizationServerMetadataEndpointMatcher.matches(request);

    public OAuth2AuthorizationServerConfigurer<B> registeredClientRepository(RegisteredClientRepository registeredClientRepository) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(RegisteredClientRepository.class, (Object)registeredClientRepository);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> authorizationService(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizationService.class, (Object)authorizationService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> authorizationConsentService(OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizationConsentService.class, (Object)authorizationConsentService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> providerSettings(ProviderSettings providerSettings) {
        Assert.notNull((Object)providerSettings, (String)"providerSettings cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ProviderSettings.class, (Object)providerSettings);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenGenerator(OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2TokenGenerator.class, tokenGenerator);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> clientAuthentication(Customizer<OAuth2ClientAuthenticationConfigurer> clientAuthenticationCustomizer) {
        clientAuthenticationCustomizer.customize((Object)this.getConfigurer(OAuth2ClientAuthenticationConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> authorizationEndpoint(Customizer<OAuth2AuthorizationEndpointConfigurer> authorizationEndpointCustomizer) {
        authorizationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenEndpoint(Customizer<OAuth2TokenEndpointConfigurer> tokenEndpointCustomizer) {
        tokenEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenIntrospectionEndpoint(Customizer<OAuth2TokenIntrospectionEndpointConfigurer> tokenIntrospectionEndpointCustomizer) {
        tokenIntrospectionEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenIntrospectionEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenRevocationEndpoint(Customizer<OAuth2TokenRevocationEndpointConfigurer> tokenRevocationEndpointCustomizer) {
        tokenRevocationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenRevocationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> oidc(Customizer<OidcConfigurer> oidcCustomizer) {
        oidcCustomizer.customize((Object)this.getConfigurer(OidcConfigurer.class));
        return this;
    }

    public RequestMatcher getEndpointsMatcher() {
        return this.endpointsMatcher;
    }

    public void init(B builder) {
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        OAuth2AuthorizationServerConfigurer.validateProviderSettings(providerSettings);
        this.initEndpointMatchers(providerSettings);
        this.configurers.values().forEach(configurer -> configurer.init(builder));
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)builder.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{this.getRequestMatcher(OAuth2TokenEndpointConfigurer.class), this.getRequestMatcher(OAuth2TokenIntrospectionEndpointConfigurer.class), this.getRequestMatcher(OAuth2TokenRevocationEndpointConfigurer.class)}));
        }
    }

    public void configure(B builder) {
        this.configurers.values().forEach(configurer -> configurer.configure(builder));
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        ProviderContextFilter providerContextFilter = new ProviderContextFilter(providerSettings);
        builder.addFilterAfter((Filter)this.postProcess((Object)providerContextFilter), SecurityContextPersistenceFilter.class);
        JWKSource<SecurityContext> jwkSource = OAuth2ConfigurerUtils.getJwkSource(builder);
        if (jwkSource != null) {
            NimbusJwkSetEndpointFilter jwkSetEndpointFilter = new NimbusJwkSetEndpointFilter(jwkSource, providerSettings.getJwkSetEndpoint());
            builder.addFilterBefore((Filter)this.postProcess((Object)jwkSetEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        }
        OAuth2AuthorizationServerMetadataEndpointFilter authorizationServerMetadataEndpointFilter = new OAuth2AuthorizationServerMetadataEndpointFilter(providerSettings);
        builder.addFilterBefore((Filter)this.postProcess((Object)authorizationServerMetadataEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }

    private Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> createConfigurers() {
        LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = new LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer>();
        configurers.put(OAuth2ClientAuthenticationConfigurer.class, new OAuth2ClientAuthenticationConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2AuthorizationEndpointConfigurer.class, new OAuth2AuthorizationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2TokenEndpointConfigurer.class, new OAuth2TokenEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2TokenIntrospectionEndpointConfigurer.class, new OAuth2TokenIntrospectionEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2TokenRevocationEndpointConfigurer.class, new OAuth2TokenRevocationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OidcConfigurer.class, new OidcConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        return configurers;
    }

    private <T> T getConfigurer(Class<T> type) {
        return (T)this.configurers.get(type);
    }

    private <T extends AbstractOAuth2Configurer> RequestMatcher getRequestMatcher(Class<T> configurerType) {
        return ((AbstractOAuth2Configurer)this.getConfigurer(configurerType)).getRequestMatcher();
    }

    private void initEndpointMatchers(ProviderSettings providerSettings) {
        this.jwkSetEndpointMatcher = new AntPathRequestMatcher(providerSettings.getJwkSetEndpoint(), HttpMethod.GET.name());
        this.authorizationServerMetadataEndpointMatcher = new AntPathRequestMatcher("/.well-known/oauth-authorization-server", HttpMethod.GET.name());
    }

    private static void validateProviderSettings(ProviderSettings providerSettings) {
        if (providerSettings.getIssuer() != null) {
            URI issuerUri;
            try {
                issuerUri = new URI(providerSettings.getIssuer());
                issuerUri.toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("issuer must be a valid URL", ex);
            }
            if (issuerUri.getQuery() != null || issuerUri.getFragment() != null) {
                throw new IllegalArgumentException("issuer cannot contain query or fragment component");
            }
        }
    }
}

