/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.ClientSecretAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.JwtClientAssertionAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.PublicClientAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.util.Assert;

@Deprecated
public final class OAuth2ClientAuthenticationProvider
implements AuthenticationProvider {
    private static final ClientAuthenticationMethod JWT_CLIENT_ASSERTION_AUTHENTICATION_METHOD = new ClientAuthenticationMethod("urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
    private final JwtClientAssertionAuthenticationProvider jwtClientAssertionAuthenticationProvider;
    private final ClientSecretAuthenticationProvider clientSecretAuthenticationProvider;
    private final PublicClientAuthenticationProvider publicClientAuthenticationProvider;

    public OAuth2ClientAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.jwtClientAssertionAuthenticationProvider = new JwtClientAssertionAuthenticationProvider(registeredClientRepository, authorizationService);
        this.clientSecretAuthenticationProvider = new ClientSecretAuthenticationProvider(registeredClientRepository, authorizationService);
        this.publicClientAuthenticationProvider = new PublicClientAuthenticationProvider(registeredClientRepository, authorizationService);
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.clientSecretAuthenticationProvider.setPasswordEncoder(passwordEncoder);
    }

    @Autowired
    protected void setProviderSettings(ProviderSettings providerSettings) {
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2ClientAuthenticationToken clientAuthentication = (OAuth2ClientAuthenticationToken)authentication;
        if (JWT_CLIENT_ASSERTION_AUTHENTICATION_METHOD.equals((Object)clientAuthentication.getClientAuthenticationMethod())) {
            return this.jwtClientAssertionAuthenticationProvider.authenticate(authentication);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)clientAuthentication.getClientAuthenticationMethod()) || ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)clientAuthentication.getClientAuthenticationMethod())) {
            return this.clientSecretAuthenticationProvider.authenticate(authentication);
        }
        return this.publicClientAuthenticationProvider.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2ClientAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

