/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.lang.Nullable;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JdbcOAuth2AuthorizationService
implements OAuth2AuthorizationService {
    private static final String COLUMN_NAMES = "id, registered_client_id, principal_name, authorization_grant_type, attributes, state, authorization_code_value, authorization_code_issued_at, authorization_code_expires_at,authorization_code_metadata,access_token_value,access_token_issued_at,access_token_expires_at,access_token_metadata,access_token_type,access_token_scopes,oidc_id_token_value,oidc_id_token_issued_at,oidc_id_token_expires_at,oidc_id_token_metadata,refresh_token_value,refresh_token_issued_at,refresh_token_expires_at,refresh_token_metadata";
    private static final String TABLE_NAME = "oauth2_authorization";
    private static final String PK_FILTER = "id = ?";
    private static final String UNKNOWN_TOKEN_TYPE_FILTER = "state = ? OR authorization_code_value = ? OR access_token_value = ? OR refresh_token_value = ?";
    private static final String STATE_FILTER = "state = ?";
    private static final String AUTHORIZATION_CODE_FILTER = "authorization_code_value = ?";
    private static final String ACCESS_TOKEN_FILTER = "access_token_value = ?";
    private static final String REFRESH_TOKEN_FILTER = "refresh_token_value = ?";
    private static final String LOAD_AUTHORIZATION_SQL = "SELECT id, registered_client_id, principal_name, authorization_grant_type, attributes, state, authorization_code_value, authorization_code_issued_at, authorization_code_expires_at,authorization_code_metadata,access_token_value,access_token_issued_at,access_token_expires_at,access_token_metadata,access_token_type,access_token_scopes,oidc_id_token_value,oidc_id_token_issued_at,oidc_id_token_expires_at,oidc_id_token_metadata,refresh_token_value,refresh_token_issued_at,refresh_token_expires_at,refresh_token_metadata FROM oauth2_authorization WHERE ";
    private static final String SAVE_AUTHORIZATION_SQL = "INSERT INTO oauth2_authorization (id, registered_client_id, principal_name, authorization_grant_type, attributes, state, authorization_code_value, authorization_code_issued_at, authorization_code_expires_at,authorization_code_metadata,access_token_value,access_token_issued_at,access_token_expires_at,access_token_metadata,access_token_type,access_token_scopes,oidc_id_token_value,oidc_id_token_issued_at,oidc_id_token_expires_at,oidc_id_token_metadata,refresh_token_value,refresh_token_issued_at,refresh_token_expires_at,refresh_token_metadata) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_AUTHORIZATION_SQL = "UPDATE oauth2_authorization SET registered_client_id = ?, principal_name = ?, authorization_grant_type = ?, attributes = ?, state = ?, authorization_code_value = ?, authorization_code_issued_at = ?, authorization_code_expires_at = ?, authorization_code_metadata = ?, access_token_value = ?, access_token_issued_at = ?, access_token_expires_at = ?, access_token_metadata = ?, access_token_type = ?, access_token_scopes = ?, oidc_id_token_value = ?, oidc_id_token_issued_at = ?, oidc_id_token_expires_at = ?, oidc_id_token_metadata = ?, refresh_token_value = ?, refresh_token_issued_at = ?, refresh_token_expires_at = ?, refresh_token_metadata = ? WHERE id = ?";
    private static final String REMOVE_AUTHORIZATION_SQL = "DELETE FROM oauth2_authorization WHERE id = ?";
    private static Map<String, ColumnMetadata> columnMetadataMap;
    private final JdbcOperations jdbcOperations;
    private final LobHandler lobHandler;
    private RowMapper<OAuth2Authorization> authorizationRowMapper;
    private Function<OAuth2Authorization, List<SqlParameterValue>> authorizationParametersMapper;

    public JdbcOAuth2AuthorizationService(JdbcOperations jdbcOperations, RegisteredClientRepository registeredClientRepository) {
        this(jdbcOperations, registeredClientRepository, (LobHandler)new DefaultLobHandler());
    }

    public JdbcOAuth2AuthorizationService(JdbcOperations jdbcOperations, RegisteredClientRepository registeredClientRepository, LobHandler lobHandler) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations cannot be null");
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)lobHandler, (String)"lobHandler cannot be null");
        this.jdbcOperations = jdbcOperations;
        this.lobHandler = lobHandler;
        OAuth2AuthorizationRowMapper authorizationRowMapper = new OAuth2AuthorizationRowMapper(registeredClientRepository);
        authorizationRowMapper.setLobHandler(lobHandler);
        this.authorizationRowMapper = authorizationRowMapper;
        this.authorizationParametersMapper = new OAuth2AuthorizationParametersMapper();
        JdbcOAuth2AuthorizationService.initColumnMetadata(jdbcOperations);
    }

    @Override
    public void save(OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        OAuth2Authorization existingAuthorization = this.findById(authorization.getId());
        if (existingAuthorization == null) {
            this.insertAuthorization(authorization);
        } else {
            this.updateAuthorization(authorization);
        }
    }

    private void updateAuthorization(OAuth2Authorization authorization) {
        List<SqlParameterValue> parameters = this.authorizationParametersMapper.apply(authorization);
        SqlParameterValue id = parameters.remove(0);
        parameters.add(id);
        try (LobCreator lobCreator = this.lobHandler.getLobCreator();){
            LobCreatorArgumentPreparedStatementSetter pss = new LobCreatorArgumentPreparedStatementSetter(lobCreator, parameters.toArray());
            this.jdbcOperations.update(UPDATE_AUTHORIZATION_SQL, (PreparedStatementSetter)pss);
        }
    }

    private void insertAuthorization(OAuth2Authorization authorization) {
        List<SqlParameterValue> parameters = this.authorizationParametersMapper.apply(authorization);
        try (LobCreator lobCreator = this.lobHandler.getLobCreator();){
            LobCreatorArgumentPreparedStatementSetter pss = new LobCreatorArgumentPreparedStatementSetter(lobCreator, parameters.toArray());
            this.jdbcOperations.update(SAVE_AUTHORIZATION_SQL, (PreparedStatementSetter)pss);
        }
    }

    @Override
    public void remove(OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)authorization.getId())};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        this.jdbcOperations.update(REMOVE_AUTHORIZATION_SQL, (PreparedStatementSetter)pss);
    }

    @Override
    @Nullable
    public OAuth2Authorization findById(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
        parameters.add(new SqlParameterValue(12, (Object)id));
        return this.findBy(PK_FILTER, parameters);
    }

    @Override
    @Nullable
    public OAuth2Authorization findByToken(String token, @Nullable OAuth2TokenType tokenType) {
        Assert.hasText((String)token, (String)"token cannot be empty");
        ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
        if (tokenType == null) {
            parameters.add(new SqlParameterValue(12, (Object)token));
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter("authorization_code_value", token));
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter("access_token_value", token));
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter("refresh_token_value", token));
            return this.findBy(UNKNOWN_TOKEN_TYPE_FILTER, parameters);
        }
        if ("state".equals(tokenType.getValue())) {
            parameters.add(new SqlParameterValue(12, (Object)token));
            return this.findBy(STATE_FILTER, parameters);
        }
        if ("code".equals(tokenType.getValue())) {
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter("authorization_code_value", token));
            return this.findBy(AUTHORIZATION_CODE_FILTER, parameters);
        }
        if (OAuth2TokenType.ACCESS_TOKEN.equals(tokenType)) {
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter("access_token_value", token));
            return this.findBy(ACCESS_TOKEN_FILTER, parameters);
        }
        if (OAuth2TokenType.REFRESH_TOKEN.equals(tokenType)) {
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter("refresh_token_value", token));
            return this.findBy(REFRESH_TOKEN_FILTER, parameters);
        }
        return null;
    }

    private OAuth2Authorization findBy(String filter, List<SqlParameterValue> parameters) {
        try (LobCreator lobCreator = this.getLobHandler().getLobCreator();){
            LobCreatorArgumentPreparedStatementSetter pss = new LobCreatorArgumentPreparedStatementSetter(lobCreator, parameters.toArray());
            List result = this.getJdbcOperations().query(LOAD_AUTHORIZATION_SQL + filter, (PreparedStatementSetter)pss, this.getAuthorizationRowMapper());
            OAuth2Authorization oAuth2Authorization = !result.isEmpty() ? (OAuth2Authorization)result.get(0) : null;
            return oAuth2Authorization;
        }
    }

    public final void setAuthorizationRowMapper(RowMapper<OAuth2Authorization> authorizationRowMapper) {
        Assert.notNull(authorizationRowMapper, (String)"authorizationRowMapper cannot be null");
        this.authorizationRowMapper = authorizationRowMapper;
    }

    public final void setAuthorizationParametersMapper(Function<OAuth2Authorization, List<SqlParameterValue>> authorizationParametersMapper) {
        Assert.notNull(authorizationParametersMapper, (String)"authorizationParametersMapper cannot be null");
        this.authorizationParametersMapper = authorizationParametersMapper;
    }

    protected final JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    protected final LobHandler getLobHandler() {
        return this.lobHandler;
    }

    protected final RowMapper<OAuth2Authorization> getAuthorizationRowMapper() {
        return this.authorizationRowMapper;
    }

    protected final Function<OAuth2Authorization, List<SqlParameterValue>> getAuthorizationParametersMapper() {
        return this.authorizationParametersMapper;
    }

    private static void initColumnMetadata(JdbcOperations jdbcOperations) {
        columnMetadataMap = new HashMap<String, ColumnMetadata>();
        ColumnMetadata columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "attributes", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "authorization_code_value", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "authorization_code_metadata", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "access_token_value", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "access_token_metadata", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "oidc_id_token_value", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "oidc_id_token_metadata", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "refresh_token_value", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
        columnMetadata = JdbcOAuth2AuthorizationService.getColumnMetadata(jdbcOperations, "refresh_token_metadata", 2004);
        columnMetadataMap.put(columnMetadata.getColumnName(), columnMetadata);
    }

    private static ColumnMetadata getColumnMetadata(JdbcOperations jdbcOperations, String columnName, int defaultDataType) {
        Integer dataType = (Integer)jdbcOperations.execute(conn -> {
            DatabaseMetaData databaseMetaData = conn.getMetaData();
            ResultSet rs = databaseMetaData.getColumns(null, null, TABLE_NAME, columnName);
            if (rs.next()) {
                return rs.getInt("DATA_TYPE");
            }
            rs = databaseMetaData.getColumns(null, null, TABLE_NAME.toUpperCase(), columnName.toUpperCase());
            if (rs.next()) {
                return rs.getInt("DATA_TYPE");
            }
            return null;
        });
        return new ColumnMetadata(columnName, dataType != null ? dataType : defaultDataType);
    }

    private static SqlParameterValue mapToSqlParameter(String columnName, String value) {
        ColumnMetadata columnMetadata = columnMetadataMap.get(columnName);
        return 2004 == columnMetadata.getDataType() && StringUtils.hasText((String)value) ? new SqlParameterValue(2004, (Object)value.getBytes(StandardCharsets.UTF_8)) : new SqlParameterValue(columnMetadata.getDataType(), (Object)value);
    }

    private static final class ColumnMetadata {
        private final String columnName;
        private final int dataType;

        private ColumnMetadata(String columnName, int dataType) {
            this.columnName = columnName;
            this.dataType = dataType;
        }

        private String getColumnName() {
            return this.columnName;
        }

        private int getDataType() {
            return this.dataType;
        }
    }

    private static final class LobCreatorArgumentPreparedStatementSetter
    extends ArgumentPreparedStatementSetter {
        private final LobCreator lobCreator;

        private LobCreatorArgumentPreparedStatementSetter(LobCreator lobCreator, Object[] args) {
            super(args);
            this.lobCreator = lobCreator;
        }

        protected void doSetValue(PreparedStatement ps, int parameterPosition, Object argValue) throws SQLException {
            if (argValue instanceof SqlParameterValue) {
                SqlParameterValue paramValue = (SqlParameterValue)argValue;
                if (paramValue.getSqlType() == 2004) {
                    if (paramValue.getValue() != null) {
                        Assert.isInstanceOf(byte[].class, (Object)paramValue.getValue(), (String)"Value of blob parameter must be byte[]");
                    }
                    byte[] valueBytes = (byte[])paramValue.getValue();
                    this.lobCreator.setBlobAsBytes(ps, parameterPosition, valueBytes);
                    return;
                }
                if (paramValue.getSqlType() == 2005) {
                    if (paramValue.getValue() != null) {
                        Assert.isInstanceOf(String.class, (Object)paramValue.getValue(), (String)"Value of clob parameter must be String");
                    }
                    String valueString = (String)paramValue.getValue();
                    this.lobCreator.setClobAsString(ps, parameterPosition, valueString);
                    return;
                }
            }
            super.doSetValue(ps, parameterPosition, argValue);
        }
    }

    public static class OAuth2AuthorizationParametersMapper
    implements Function<OAuth2Authorization, List<SqlParameterValue>> {
        private ObjectMapper objectMapper = new ObjectMapper();

        public OAuth2AuthorizationParametersMapper() {
            ClassLoader classLoader = JdbcOAuth2AuthorizationService.class.getClassLoader();
            List securityModules = SecurityJackson2Modules.getModules((ClassLoader)classLoader);
            this.objectMapper.registerModules((Iterable)securityModules);
            this.objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        }

        @Override
        public List<SqlParameterValue> apply(OAuth2Authorization authorization) {
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            parameters.add(new SqlParameterValue(12, (Object)authorization.getId()));
            parameters.add(new SqlParameterValue(12, (Object)authorization.getRegisteredClientId()));
            parameters.add(new SqlParameterValue(12, (Object)authorization.getPrincipalName()));
            parameters.add(new SqlParameterValue(12, (Object)authorization.getAuthorizationGrantType().getValue()));
            String attributes = this.writeMap(authorization.getAttributes());
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter("attributes", attributes));
            String state = null;
            String authorizationState = (String)authorization.getAttribute("state");
            if (StringUtils.hasText((String)authorizationState)) {
                state = authorizationState;
            }
            parameters.add(new SqlParameterValue(12, (Object)state));
            OAuth2Authorization.Token<OAuth2AuthorizationCode> authorizationCode = authorization.getToken(OAuth2AuthorizationCode.class);
            List<SqlParameterValue> authorizationCodeSqlParameters = this.toSqlParameterList("authorization_code_value", "authorization_code_metadata", authorizationCode);
            parameters.addAll(authorizationCodeSqlParameters);
            OAuth2Authorization.Token<OAuth2AccessToken> accessToken = authorization.getToken(OAuth2AccessToken.class);
            List<SqlParameterValue> accessTokenSqlParameters = this.toSqlParameterList("access_token_value", "access_token_metadata", accessToken);
            parameters.addAll(accessTokenSqlParameters);
            String accessTokenType = null;
            String accessTokenScopes = null;
            if (accessToken != null) {
                accessTokenType = accessToken.getToken().getTokenType().getValue();
                if (!CollectionUtils.isEmpty((Collection)accessToken.getToken().getScopes())) {
                    accessTokenScopes = StringUtils.collectionToDelimitedString((Collection)accessToken.getToken().getScopes(), (String)",");
                }
            }
            parameters.add(new SqlParameterValue(12, (Object)accessTokenType));
            parameters.add(new SqlParameterValue(12, accessTokenScopes));
            OAuth2Authorization.Token<OidcIdToken> oidcIdToken = authorization.getToken(OidcIdToken.class);
            List<SqlParameterValue> oidcIdTokenSqlParameters = this.toSqlParameterList("oidc_id_token_value", "oidc_id_token_metadata", oidcIdToken);
            parameters.addAll(oidcIdTokenSqlParameters);
            OAuth2Authorization.Token<OAuth2RefreshToken> refreshToken = authorization.getRefreshToken();
            List<SqlParameterValue> refreshTokenSqlParameters = this.toSqlParameterList("refresh_token_value", "refresh_token_metadata", refreshToken);
            parameters.addAll(refreshTokenSqlParameters);
            return parameters;
        }

        public final void setObjectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
            this.objectMapper = objectMapper;
        }

        protected final ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        private <T extends AbstractOAuth2Token> List<SqlParameterValue> toSqlParameterList(String tokenColumnName, String tokenMetadataColumnName, OAuth2Authorization.Token<T> token) {
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            String tokenValue = null;
            Timestamp tokenIssuedAt = null;
            Timestamp tokenExpiresAt = null;
            String metadata = null;
            if (token != null) {
                tokenValue = ((AbstractOAuth2Token)token.getToken()).getTokenValue();
                if (((AbstractOAuth2Token)token.getToken()).getIssuedAt() != null) {
                    tokenIssuedAt = Timestamp.from(((AbstractOAuth2Token)token.getToken()).getIssuedAt());
                }
                if (((AbstractOAuth2Token)token.getToken()).getExpiresAt() != null) {
                    tokenExpiresAt = Timestamp.from(((AbstractOAuth2Token)token.getToken()).getExpiresAt());
                }
                metadata = this.writeMap(token.getMetadata());
            }
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter(tokenColumnName, tokenValue));
            parameters.add(new SqlParameterValue(93, tokenIssuedAt));
            parameters.add(new SqlParameterValue(93, tokenExpiresAt));
            parameters.add(JdbcOAuth2AuthorizationService.mapToSqlParameter(tokenMetadataColumnName, metadata));
            return parameters;
        }

        private String writeMap(Map<String, Object> data) {
            try {
                return this.objectMapper.writeValueAsString(data);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
    }

    public static class OAuth2AuthorizationRowMapper
    implements RowMapper<OAuth2Authorization> {
        private final RegisteredClientRepository registeredClientRepository;
        private LobHandler lobHandler = new DefaultLobHandler();
        private ObjectMapper objectMapper = new ObjectMapper();

        public OAuth2AuthorizationRowMapper(RegisteredClientRepository registeredClientRepository) {
            Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
            this.registeredClientRepository = registeredClientRepository;
            ClassLoader classLoader = JdbcOAuth2AuthorizationService.class.getClassLoader();
            List securityModules = SecurityJackson2Modules.getModules((ClassLoader)classLoader);
            this.objectMapper.registerModules((Iterable)securityModules);
            this.objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        }

        public OAuth2Authorization mapRow(ResultSet rs, int rowNum) throws SQLException {
            String refreshTokenValue;
            String oidcIdTokenValue;
            String accessTokenValue;
            Instant tokenExpiresAt;
            Instant tokenIssuedAt;
            String authorizationCodeValue;
            String registeredClientId = rs.getString("registered_client_id");
            RegisteredClient registeredClient = this.registeredClientRepository.findById(registeredClientId);
            if (registeredClient == null) {
                throw new DataRetrievalFailureException("The RegisteredClient with id '" + registeredClientId + "' was not found in the RegisteredClientRepository.");
            }
            OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient(registeredClient);
            String id = rs.getString("id");
            String principalName = rs.getString("principal_name");
            String authorizationGrantType = rs.getString("authorization_grant_type");
            Map<String, Object> attributes = this.parseMap(this.getLobValue(rs, "attributes"));
            builder.id(id).principalName(principalName).authorizationGrantType(new AuthorizationGrantType(authorizationGrantType)).attributes(attrs -> attrs.putAll(attributes));
            String state = rs.getString("state");
            if (StringUtils.hasText((String)state)) {
                builder.attribute("state", state);
            }
            if (StringUtils.hasText((String)(authorizationCodeValue = this.getLobValue(rs, "authorization_code_value")))) {
                tokenIssuedAt = rs.getTimestamp("authorization_code_issued_at").toInstant();
                tokenExpiresAt = rs.getTimestamp("authorization_code_expires_at").toInstant();
                Map<String, Object> authorizationCodeMetadata = this.parseMap(this.getLobValue(rs, "authorization_code_metadata"));
                OAuth2AuthorizationCode authorizationCode = new OAuth2AuthorizationCode(authorizationCodeValue, tokenIssuedAt, tokenExpiresAt);
                builder.token(authorizationCode, metadata -> metadata.putAll(authorizationCodeMetadata));
            }
            if (StringUtils.hasText((String)(accessTokenValue = this.getLobValue(rs, "access_token_value")))) {
                tokenIssuedAt = rs.getTimestamp("access_token_issued_at").toInstant();
                tokenExpiresAt = rs.getTimestamp("access_token_expires_at").toInstant();
                Map<String, Object> accessTokenMetadata = this.parseMap(this.getLobValue(rs, "access_token_metadata"));
                OAuth2AccessToken.TokenType tokenType = null;
                if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(rs.getString("access_token_type"))) {
                    tokenType = OAuth2AccessToken.TokenType.BEARER;
                }
                Set scopes = Collections.emptySet();
                String accessTokenScopes = rs.getString("access_token_scopes");
                if (accessTokenScopes != null) {
                    scopes = StringUtils.commaDelimitedListToSet((String)accessTokenScopes);
                }
                OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType, accessTokenValue, tokenIssuedAt, tokenExpiresAt, scopes);
                builder.token(accessToken, metadata -> metadata.putAll(accessTokenMetadata));
            }
            if (StringUtils.hasText((String)(oidcIdTokenValue = this.getLobValue(rs, "oidc_id_token_value")))) {
                tokenIssuedAt = rs.getTimestamp("oidc_id_token_issued_at").toInstant();
                tokenExpiresAt = rs.getTimestamp("oidc_id_token_expires_at").toInstant();
                Map<String, Object> oidcTokenMetadata = this.parseMap(this.getLobValue(rs, "oidc_id_token_metadata"));
                OidcIdToken oidcToken = new OidcIdToken(oidcIdTokenValue, tokenIssuedAt, tokenExpiresAt, (Map)oidcTokenMetadata.get(OAuth2Authorization.Token.CLAIMS_METADATA_NAME));
                builder.token(oidcToken, metadata -> metadata.putAll(oidcTokenMetadata));
            }
            if (StringUtils.hasText((String)(refreshTokenValue = this.getLobValue(rs, "refresh_token_value")))) {
                tokenIssuedAt = rs.getTimestamp("refresh_token_issued_at").toInstant();
                tokenExpiresAt = null;
                Timestamp refreshTokenExpiresAt = rs.getTimestamp("refresh_token_expires_at");
                if (refreshTokenExpiresAt != null) {
                    tokenExpiresAt = refreshTokenExpiresAt.toInstant();
                }
                Map<String, Object> refreshTokenMetadata = this.parseMap(this.getLobValue(rs, "refresh_token_metadata"));
                OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(refreshTokenValue, tokenIssuedAt, tokenExpiresAt);
                builder.token(refreshToken, metadata -> metadata.putAll(refreshTokenMetadata));
            }
            return builder.build();
        }

        private String getLobValue(ResultSet rs, String columnName) throws SQLException {
            String columnValue = null;
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadataMap.get(columnName);
            if (2004 == columnMetadata.getDataType()) {
                byte[] columnValueBytes = this.lobHandler.getBlobAsBytes(rs, columnName);
                if (columnValueBytes != null) {
                    columnValue = new String(columnValueBytes, StandardCharsets.UTF_8);
                }
            } else {
                columnValue = 2005 == columnMetadata.getDataType() ? this.lobHandler.getClobAsString(rs, columnName) : rs.getString(columnName);
            }
            return columnValue;
        }

        public final void setLobHandler(LobHandler lobHandler) {
            Assert.notNull((Object)lobHandler, (String)"lobHandler cannot be null");
            this.lobHandler = lobHandler;
        }

        public final void setObjectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
            this.objectMapper = objectMapper;
        }

        protected final RegisteredClientRepository getRegisteredClientRepository() {
            return this.registeredClientRepository;
        }

        protected final LobHandler getLobHandler() {
            return this.lobHandler;
        }

        protected final ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        private Map<String, Object> parseMap(String data) {
            try {
                return (Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
    }
}

