/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwsEncoder;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.token.DelegatingOAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.JwtGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2AccessTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2RefreshTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.StringUtils;

final class OAuth2ConfigurerUtils {
    private OAuth2ConfigurerUtils() {
    }

    static <B extends HttpSecurityBuilder<B>> RegisteredClientRepository getRegisteredClientRepository(B builder) {
        RegisteredClientRepository registeredClientRepository = (RegisteredClientRepository)builder.getSharedObject(RegisteredClientRepository.class);
        if (registeredClientRepository == null) {
            registeredClientRepository = OAuth2ConfigurerUtils.getBean(builder, RegisteredClientRepository.class);
            builder.setSharedObject(RegisteredClientRepository.class, (Object)registeredClientRepository);
        }
        return registeredClientRepository;
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizationService getAuthorizationService(B builder) {
        OAuth2AuthorizationService authorizationService = (OAuth2AuthorizationService)builder.getSharedObject(OAuth2AuthorizationService.class);
        if (authorizationService == null) {
            authorizationService = OAuth2ConfigurerUtils.getOptionalBean(builder, OAuth2AuthorizationService.class);
            if (authorizationService == null) {
                authorizationService = new InMemoryOAuth2AuthorizationService();
            }
            builder.setSharedObject(OAuth2AuthorizationService.class, (Object)authorizationService);
        }
        return authorizationService;
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizationConsentService getAuthorizationConsentService(B builder) {
        OAuth2AuthorizationConsentService authorizationConsentService = (OAuth2AuthorizationConsentService)builder.getSharedObject(OAuth2AuthorizationConsentService.class);
        if (authorizationConsentService == null) {
            authorizationConsentService = OAuth2ConfigurerUtils.getOptionalBean(builder, OAuth2AuthorizationConsentService.class);
            if (authorizationConsentService == null) {
                authorizationConsentService = new InMemoryOAuth2AuthorizationConsentService();
            }
            builder.setSharedObject(OAuth2AuthorizationConsentService.class, (Object)authorizationConsentService);
        }
        return authorizationConsentService;
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2TokenGenerator<? extends OAuth2Token> getTokenGenerator(B builder) {
        OAuth2TokenGenerator tokenGenerator = (OAuth2TokenGenerator)builder.getSharedObject(OAuth2TokenGenerator.class);
        if (tokenGenerator == null) {
            tokenGenerator = OAuth2ConfigurerUtils.getOptionalBean(builder, OAuth2TokenGenerator.class);
            if (tokenGenerator == null) {
                JwtGenerator jwtGenerator = OAuth2ConfigurerUtils.getJwtGenerator(builder);
                OAuth2AccessTokenGenerator accessTokenGenerator = new OAuth2AccessTokenGenerator();
                OAuth2TokenCustomizer<OAuth2TokenClaimsContext> accessTokenCustomizer = OAuth2ConfigurerUtils.getAccessTokenCustomizer(builder);
                if (accessTokenCustomizer != null) {
                    accessTokenGenerator.setAccessTokenCustomizer(accessTokenCustomizer);
                }
                OAuth2RefreshTokenGenerator refreshTokenGenerator = new OAuth2RefreshTokenGenerator();
                tokenGenerator = jwtGenerator != null ? new DelegatingOAuth2TokenGenerator(jwtGenerator, accessTokenGenerator, refreshTokenGenerator) : new DelegatingOAuth2TokenGenerator(accessTokenGenerator, refreshTokenGenerator);
            }
            builder.setSharedObject(OAuth2TokenGenerator.class, (Object)tokenGenerator);
        }
        return tokenGenerator;
    }

    private static <B extends HttpSecurityBuilder<B>> JwtGenerator getJwtGenerator(B builder) {
        JwtEncoder jwtEncoder;
        JwtGenerator jwtGenerator = (JwtGenerator)builder.getSharedObject(JwtGenerator.class);
        if (jwtGenerator == null && (jwtEncoder = OAuth2ConfigurerUtils.getJwtEncoder(builder)) != null) {
            jwtGenerator = new JwtGenerator(jwtEncoder);
            OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer = OAuth2ConfigurerUtils.getJwtCustomizer(builder);
            if (jwtCustomizer != null) {
                jwtGenerator.setJwtCustomizer(jwtCustomizer);
            }
            builder.setSharedObject(JwtGenerator.class, (Object)jwtGenerator);
        }
        return jwtGenerator;
    }

    private static <B extends HttpSecurityBuilder<B>> JwtEncoder getJwtEncoder(B builder) {
        JwtEncoder jwtEncoder = (JwtEncoder)builder.getSharedObject(JwtEncoder.class);
        if (jwtEncoder == null) {
            JWKSource<SecurityContext> jwkSource;
            jwtEncoder = OAuth2ConfigurerUtils.getOptionalBean(builder, JwtEncoder.class);
            if (jwtEncoder == null && (jwkSource = OAuth2ConfigurerUtils.getJwkSource(builder)) != null) {
                jwtEncoder = new NimbusJwsEncoder(jwkSource);
            }
            if (jwtEncoder != null) {
                builder.setSharedObject(JwtEncoder.class, (Object)jwtEncoder);
            }
        }
        return jwtEncoder;
    }

    static <B extends HttpSecurityBuilder<B>> JWKSource<SecurityContext> getJwkSource(B builder) {
        ResolvableType type;
        JWKSource jwkSource = (JWKSource)builder.getSharedObject(JWKSource.class);
        if (jwkSource == null && (jwkSource = (JWKSource)OAuth2ConfigurerUtils.getOptionalBean(builder, type = ResolvableType.forClassWithGenerics(JWKSource.class, (Class[])new Class[]{SecurityContext.class}))) != null) {
            builder.setSharedObject(JWKSource.class, (Object)jwkSource);
        }
        return jwkSource;
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2TokenCustomizer<JwtEncodingContext> getJwtCustomizer(B builder) {
        ResolvableType type = ResolvableType.forClassWithGenerics(OAuth2TokenCustomizer.class, (Class[])new Class[]{JwtEncodingContext.class});
        return (OAuth2TokenCustomizer)OAuth2ConfigurerUtils.getOptionalBean(builder, type);
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2TokenCustomizer<OAuth2TokenClaimsContext> getAccessTokenCustomizer(B builder) {
        ResolvableType type = ResolvableType.forClassWithGenerics(OAuth2TokenCustomizer.class, (Class[])new Class[]{OAuth2TokenClaimsContext.class});
        return (OAuth2TokenCustomizer)OAuth2ConfigurerUtils.getOptionalBean(builder, type);
    }

    static <B extends HttpSecurityBuilder<B>> ProviderSettings getProviderSettings(B builder) {
        ProviderSettings providerSettings = (ProviderSettings)builder.getSharedObject(ProviderSettings.class);
        if (providerSettings == null) {
            providerSettings = OAuth2ConfigurerUtils.getBean(builder, ProviderSettings.class);
            builder.setSharedObject(ProviderSettings.class, (Object)providerSettings);
        }
        return providerSettings;
    }

    static <B extends HttpSecurityBuilder<B>, T> T getBean(B builder, Class<T> type) {
        return (T)((ApplicationContext)builder.getSharedObject(ApplicationContext.class)).getBean(type);
    }

    static <B extends HttpSecurityBuilder<B>, T> T getBean(B builder, ResolvableType type) {
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)context.getBean(names[0]);
        }
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        throw new NoSuchBeanDefinitionException(type);
    }

    static <B extends HttpSecurityBuilder<B>, T> T getOptionalBean(B builder, Class<T> type) {
        Map beansMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)builder.getSharedObject(ApplicationContext.class)), type);
        if (beansMap.size() > 1) {
            throw new NoUniqueBeanDefinitionException(type, beansMap.size(), "Expected single matching bean of type '" + type.getName() + "' but found " + beansMap.size() + ": " + StringUtils.collectionToCommaDelimitedString(beansMap.keySet()));
        }
        return !beansMap.isEmpty() ? (T)beansMap.values().iterator().next() : null;
    }

    static <B extends HttpSecurityBuilder<B>, T> T getOptionalBean(B builder, ResolvableType type) {
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        return (T)(names.length == 1 ? context.getBean(names[0]) : null);
    }
}

