/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.springframework.aop.support.AopUtils;
import org.springframework.expression.Expression;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.ExpressionAttribute;

final class PreFilterExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<PreFilterExpressionAttribute> {
    PreFilterExpressionAttributeRegistry() {
    }

    @Override
    @NonNull
    PreFilterExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        PreFilter preFilter = this.findPreFilterAnnotation(specificMethod, targetClass);
        if (preFilter == null) {
            return PreFilterExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression preFilterExpression = this.getExpressionHandler().getExpressionParser().parseExpression(preFilter.value());
        return new PreFilterExpressionAttribute(preFilterExpression, preFilter.filterTarget());
    }

    private PreFilter findPreFilterAnnotation(Method method, Class<?> targetClass) {
        Function<AnnotatedElement, PreFilter> lookup = this.findUniqueAnnotation(PreFilter.class);
        PreFilter preFilter = lookup.apply(method);
        return preFilter != null ? preFilter : lookup.apply(this.targetClass(method, targetClass));
    }

    static final class PreFilterExpressionAttribute
    extends ExpressionAttribute {
        static final PreFilterExpressionAttribute NULL_ATTRIBUTE = new PreFilterExpressionAttribute(null, null);
        private final String filterTarget;

        private PreFilterExpressionAttribute(Expression expression, String filterTarget) {
            super(expression);
            this.filterTarget = filterTarget;
        }

        String getFilterTarget() {
            return this.filterTarget;
        }
    }
}

