/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public final class AuthorityAuthorizationManager<T>
implements AuthorizationManager<T> {
    private static final String ROLE_PREFIX = "ROLE_";
    private final Set<String> authorities;

    private AuthorityAuthorizationManager(String ... authorities) {
        this.authorities = new HashSet<String>(Arrays.asList(authorities));
    }

    public static <T> AuthorityAuthorizationManager<T> hasRole(String role) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        return AuthorityAuthorizationManager.hasAuthority(ROLE_PREFIX + role);
    }

    public static <T> AuthorityAuthorizationManager<T> hasAuthority(String authority) {
        Assert.notNull((Object)authority, (String)"authority cannot be null");
        return new AuthorityAuthorizationManager<T>(authority);
    }

    public static <T> AuthorityAuthorizationManager<T> hasAnyRole(String ... roles) {
        Assert.notEmpty((Object[])roles, (String)"roles cannot be empty");
        Assert.noNullElements((Object[])roles, (String)"roles cannot contain null values");
        return AuthorityAuthorizationManager.hasAnyAuthority(AuthorityAuthorizationManager.toNamedRolesArray(roles));
    }

    public static <T> AuthorityAuthorizationManager<T> hasAnyAuthority(String ... authorities) {
        Assert.notEmpty((Object[])authorities, (String)"authorities cannot be empty");
        Assert.noNullElements((Object[])authorities, (String)"authorities cannot contain null values");
        return new AuthorityAuthorizationManager<T>(authorities);
    }

    private static String[] toNamedRolesArray(String ... roles) {
        String[] result = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            result[i] = ROLE_PREFIX + roles[i];
        }
        return result;
    }

    @Override
    public AuthorizationDecision check(Supplier<Authentication> authentication, T object) {
        boolean granted = this.isGranted(authentication.get());
        return new AuthorizationDecision(granted);
    }

    private boolean isGranted(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated() && this.isAuthorized(authentication);
    }

    private boolean isAuthorized(Authentication authentication) {
        for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
            String authority = grantedAuthority.getAuthority();
            if (!this.authorities.contains(authority)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AuthorityAuthorizationManager[authorities=" + this.authorities + "]";
    }
}

