/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.parameters.DefaultSecurityParameterNameDiscoverer;

class MethodSecurityEvaluationContext
extends StandardEvaluationContext {
    private static final Log logger = LogFactory.getLog(MethodSecurityEvaluationContext.class);
    private ParameterNameDiscoverer parameterNameDiscoverer;
    private final MethodInvocation mi;
    private boolean argumentsAdded;

    MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi) {
        this(user, mi, (ParameterNameDiscoverer)new DefaultSecurityParameterNameDiscoverer());
    }

    MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi, ParameterNameDiscoverer parameterNameDiscoverer) {
        this.mi = mi;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public Object lookupVariable(String name) {
        Object variable = super.lookupVariable(name);
        if (variable != null) {
            return variable;
        }
        if (!this.argumentsAdded) {
            this.addArgumentsAsVariables();
            this.argumentsAdded = true;
        }
        if ((variable = super.lookupVariable(name)) != null) {
            return variable;
        }
        return null;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    private void addArgumentsAsVariables() {
        Method method;
        String[] paramNames;
        Object[] args = this.mi.getArguments();
        if (args.length == 0) {
            return;
        }
        Object targetObject = this.mi.getThis();
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)targetObject);
        if (targetClass == null) {
            targetClass = targetObject.getClass();
        }
        if ((paramNames = this.parameterNameDiscoverer.getParameterNames(method = AopUtils.getMostSpecificMethod((Method)this.mi.getMethod(), targetClass))) == null) {
            logger.warn((Object)("Unable to resolve method parameter names for method: " + method + ". Debug symbol information is required if you are using parameter names in expressions."));
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (paramNames[i] == null) continue;
            this.setVariable(paramNames[i], args[i]);
        }
    }
}

