/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public final class SecurityJackson2Modules {
    private static final Log logger = LogFactory.getLog(SecurityJackson2Modules.class);
    private static final List<String> securityJackson2ModuleClasses = Arrays.asList("org.springframework.security.jackson2.CoreJackson2Module", "org.springframework.security.cas.jackson2.CasJackson2Module", "org.springframework.security.web.jackson2.WebJackson2Module");

    private SecurityJackson2Modules() {
    }

    public static void enableDefaultTyping(ObjectMapper mapper) {
        TypeResolverBuilder typeBuilder;
        if (mapper != null && (typeBuilder = mapper.getDeserializationConfig().getDefaultTyper(null)) == null) {
            mapper.setDefaultTyping(SecurityJackson2Modules.createWhitelistedDefaultTyping());
        }
    }

    private static Module loadAndGetInstance(String className, ClassLoader loader) {
        Module instance;
        block4: {
            instance = null;
            try {
                Class securityModule = ClassUtils.forName((String)className, (ClassLoader)loader);
                if (securityModule != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Loaded module " + className + ", now registering"));
                    }
                    instance = (Module)securityModule.newInstance();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)("Cannot load module " + className), (Throwable)e);
            }
        }
        return instance;
    }

    public static List<Module> getModules(ClassLoader loader) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String className : securityJackson2ModuleClasses) {
            Module module = SecurityJackson2Modules.loadAndGetInstance(className, loader);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    private static TypeResolverBuilder<? extends TypeResolverBuilder> createWhitelistedDefaultTyping() {
        WhitelistTypeResolverBuilder result = new WhitelistTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL);
        result = result.init(JsonTypeInfo.Id.CLASS, null);
        result = result.inclusion(JsonTypeInfo.As.PROPERTY);
        return result;
    }

    static class WhitelistTypeIdResolver
    implements TypeIdResolver {
        private static final Set<String> WHITELIST_CLASS_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.util.ArrayList", "java.util.Collections$EmptyList", "java.util.Collections$EmptyMap", "java.util.Collections$UnmodifiableRandomAccessList", "java.util.Collections$SingletonList", "java.util.Date", "java.util.TreeMap", "java.util.HashMap", "org.springframework.security.core.context.SecurityContextImpl")));
        private final TypeIdResolver delegate;

        WhitelistTypeIdResolver(TypeIdResolver delegate) {
            this.delegate = delegate;
        }

        public void init(JavaType baseType) {
            this.delegate.init(baseType);
        }

        public String idFromValue(Object value) {
            return this.delegate.idFromValue(value);
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            return this.delegate.idFromValueAndType(value, suggestedType);
        }

        public String idFromBaseType() {
            return this.delegate.idFromBaseType();
        }

        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            boolean isExplicitMixin;
            DeserializationConfig config = (DeserializationConfig)context.getConfig();
            JavaType result = this.delegate.typeFromId(context, id);
            String className = result.getRawClass().getName();
            if (this.isWhitelisted(className)) {
                return this.delegate.typeFromId(context, id);
            }
            boolean bl = isExplicitMixin = config.findMixInClassFor(result.getRawClass()) != null;
            if (isExplicitMixin) {
                return result;
            }
            JacksonAnnotation jacksonAnnotation = (JacksonAnnotation)AnnotationUtils.findAnnotation((Class)result.getRawClass(), JacksonAnnotation.class);
            if (jacksonAnnotation != null) {
                return result;
            }
            throw new IllegalArgumentException("The class with " + id + " and name of " + className + " is not whitelisted. " + "If you believe this class is safe to deserialize, please provide an explicit mapping using Jackson annotations or by providing a Mixin. " + "If the serialization is only done by a trusted source, you can also enable default typing. " + "See https://github.com/spring-projects/spring-security/issues/4370 for details");
        }

        private boolean isWhitelisted(String id) {
            return WHITELIST_CLASS_NAMES.contains(id);
        }

        public String getDescForKnownTypeIds() {
            return this.delegate.getDescForKnownTypeIds();
        }

        public JsonTypeInfo.Id getMechanism() {
            return this.delegate.getMechanism();
        }
    }

    static class WhitelistTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        public WhitelistTypeResolverBuilder(ObjectMapper.DefaultTyping defaultTyping) {
            super(defaultTyping);
        }

        protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
            TypeIdResolver result = super.idResolver(config, baseType, subtypes, forSer, forDeser);
            return new WhitelistTypeIdResolver(result);
        }
    }
}

