/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.security.util.SimpleMethodInvocation;
import org.springframework.util.Assert;

public final class MethodInvocationUtils {
    public static MethodInvocation create(Object object, String methodName, Object ... args) {
        Advised a;
        Assert.notNull((Object)object, (String)"Object required");
        Class[] classArgs = null;
        if (args != null) {
            classArgs = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                classArgs[i] = args[i].getClass();
            }
        }
        Class target = AopUtils.getTargetClass((Object)object);
        if (object instanceof Advised && !(a = (Advised)object).isProxyTargetClass()) {
            Class[] possibleInterfaces;
            for (Class possibleInterface : possibleInterfaces = a.getProxiedInterfaces()) {
                try {
                    possibleInterface.getMethod(methodName, classArgs);
                    target = possibleInterface;
                    break;
                }
                catch (Exception ignored) {
                }
            }
        }
        return MethodInvocationUtils.createFromClass(object, target, methodName, classArgs, args);
    }

    public static MethodInvocation createFromClass(Class<?> clazz, String methodName) {
        MethodInvocation mi = MethodInvocationUtils.createFromClass(null, clazz, methodName, null, null);
        if (mi == null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                if (mi != null) {
                    throw new IllegalArgumentException("The class " + clazz + " has more than one method named" + " '" + methodName + "'");
                }
                mi = new SimpleMethodInvocation(null, m, new Object[0]);
            }
        }
        return mi;
    }

    public static MethodInvocation createFromClass(Object targetObject, Class<?> clazz, String methodName, Class<?>[] classArgs, Object[] args) {
        Method method;
        Assert.notNull(clazz, (String)"Class required");
        Assert.hasText((String)methodName, (String)"MethodName required");
        try {
            method = clazz.getMethod(methodName, classArgs);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return new SimpleMethodInvocation(targetObject, method, args);
    }
}

