/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.core.Authentication;
import org.springframework.util.ClassUtils;

class MethodSecurityEvaluationContext
extends StandardEvaluationContext {
    private ParameterNameDiscoverer parameterNameDiscoverer;
    private boolean argumentsAdded;
    private MethodInvocation mi;

    public MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi) {
        this(user, mi, (ParameterNameDiscoverer)new LocalVariableTableParameterNameDiscoverer());
    }

    public MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi, ParameterNameDiscoverer parameterNameDiscoverer) {
        this.mi = mi;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public Object lookupVariable(String name) {
        Object variable = super.lookupVariable(name);
        if (variable != null) {
            return variable;
        }
        if (!this.argumentsAdded) {
            this.addArgumentsAsVariables();
            this.argumentsAdded = true;
        }
        return super.lookupVariable(name);
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    private void addArgumentsAsVariables() {
        Object[] args = this.mi.getArguments();
        Object targetObject = this.mi.getThis();
        Method method = ClassUtils.getMostSpecificMethod((Method)this.mi.getMethod(), targetObject.getClass());
        String[] paramNames = this.parameterNameDiscoverer.getParameterNames(method);
        for (int i = 0; i < args.length; ++i) {
            super.setVariable(paramNames[i], args[i]);
        }
    }
}

