/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.security.Authentication;
import org.springframework.security.acls.AccessControlEntry;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.AlreadyExistsException;
import org.springframework.security.acls.ChildrenExistException;
import org.springframework.security.acls.MutableAcl;
import org.springframework.security.acls.MutableAclService;
import org.springframework.security.acls.NotFoundException;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.jdbc.AclCache;
import org.springframework.security.acls.jdbc.JdbcAclService;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityImpl;
import org.springframework.security.acls.sid.GrantedAuthoritySid;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class JdbcMutableAclService
extends JdbcAclService
implements MutableAclService {
    private boolean foreignKeysInDatabase = true;
    private AclCache aclCache;
    private String deleteEntryByObjectIdentityForeignKey = "delete from acl_entry where acl_object_identity=?";
    private String deleteObjectIdentityByPrimaryKey = "delete from acl_object_identity where id=?";
    private String classIdentityQuery = "call identity()";
    private String sidIdentityQuery = "call identity()";
    private String insertClass = "insert into acl_class (class) values (?)";
    private String insertEntry = "insert into acl_entry (acl_object_identity, ace_order, sid, mask, granting, audit_success, audit_failure)values (?, ?, ?, ?, ?, ?, ?)";
    private String insertObjectIdentity = "insert into acl_object_identity (object_id_class, object_id_identity, owner_sid, entries_inheriting) values (?, ?, ?, ?)";
    private String insertSid = "insert into acl_sid (principal, sid) values (?, ?)";
    private String selectClassPrimaryKey = "select id from acl_class where class=?";
    private String selectObjectIdentityPrimaryKey = "select acl_object_identity.id from acl_object_identity, acl_class where acl_object_identity.object_id_class = acl_class.id and acl_class.class=? and acl_object_identity.object_id_identity = ?";
    private String selectSidPrimaryKey = "select id from acl_sid where principal=? and sid=?";
    private String updateObjectIdentity = "update acl_object_identity set parent_object = ?, owner_sid = ?, entries_inheriting = ? where id = ?";
    static /* synthetic */ Class class$org$springframework$security$acls$MutableAcl;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$org$springframework$security$acls$objectidentity$ObjectIdentityImpl;

    public JdbcMutableAclService(DataSource dataSource, LookupStrategy lookupStrategy, AclCache aclCache) {
        super(dataSource, lookupStrategy);
        Assert.notNull((Object)aclCache, (String)"AclCache required");
        this.aclCache = aclCache;
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) throws AlreadyExistsException {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        if (this.retrieveObjectIdentityPrimaryKey(objectIdentity) != null) {
            throw new AlreadyExistsException("Object identity '" + objectIdentity + "' already exists");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid sid = new PrincipalSid(auth);
        this.createObjectIdentity(objectIdentity, sid);
        Acl acl = this.readAclById(objectIdentity);
        Assert.isInstanceOf((Class)(class$org$springframework$security$acls$MutableAcl == null ? (class$org$springframework$security$acls$MutableAcl = JdbcMutableAclService.class$("org.springframework.security.acls.MutableAcl")) : class$org$springframework$security$acls$MutableAcl), (Object)acl, (String)"MutableAcl should be been returned");
        return (MutableAcl)acl;
    }

    protected void createEntries(final MutableAcl acl) {
        this.jdbcTemplate.batchUpdate(this.insertEntry, new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return acl.getEntries().length;
            }

            public void setValues(PreparedStatement stmt, int i) throws SQLException {
                AccessControlEntry entry_ = (AccessControlEntry)Array.get(acl.getEntries(), i);
                Assert.isTrue((boolean)(entry_ instanceof AccessControlEntryImpl), (String)"Unknown ACE class");
                AccessControlEntryImpl entry = (AccessControlEntryImpl)entry_;
                stmt.setLong(1, (Long)acl.getId());
                stmt.setInt(2, i);
                stmt.setLong(3, JdbcMutableAclService.this.createOrRetrieveSidPrimaryKey(entry.getSid(), true));
                stmt.setInt(4, entry.getPermission().getMask());
                stmt.setBoolean(5, entry.isGranting());
                stmt.setBoolean(6, entry.isAuditSuccess());
                stmt.setBoolean(7, entry.isAuditFailure());
            }
        });
    }

    protected void createObjectIdentity(ObjectIdentity object, Sid owner) {
        Long sidId = this.createOrRetrieveSidPrimaryKey(owner, true);
        Long classId = this.createOrRetrieveClassPrimaryKey(object.getJavaType(), true);
        this.jdbcTemplate.update(this.insertObjectIdentity, new Object[]{classId, object.getIdentifier().toString(), sidId, new Boolean(true)});
    }

    protected Long createOrRetrieveClassPrimaryKey(Class clazz, boolean allowCreate) {
        List classIds = this.jdbcTemplate.queryForList(this.selectClassPrimaryKey, new Object[]{clazz.getName()}, class$java$lang$Long == null ? (class$java$lang$Long = JdbcMutableAclService.class$("java.lang.Long")) : class$java$lang$Long);
        Long classId = null;
        if (classIds.isEmpty()) {
            if (allowCreate) {
                classId = null;
                this.jdbcTemplate.update(this.insertClass, new Object[]{clazz.getName()});
                Assert.isTrue((boolean)TransactionSynchronizationManager.isSynchronizationActive(), (String)"Transaction must be running");
                classId = new Long(this.jdbcTemplate.queryForLong(this.classIdentityQuery));
            }
        } else {
            classId = (Long)classIds.iterator().next();
        }
        return classId;
    }

    protected Long createOrRetrieveSidPrimaryKey(Sid sid, boolean allowCreate) {
        Assert.notNull((Object)sid, (String)"Sid required");
        String sidName = null;
        boolean principal = true;
        if (sid instanceof PrincipalSid) {
            sidName = ((PrincipalSid)sid).getPrincipal();
        } else if (sid instanceof GrantedAuthoritySid) {
            sidName = ((GrantedAuthoritySid)sid).getGrantedAuthority();
            principal = false;
        } else {
            throw new IllegalArgumentException("Unsupported implementation of Sid");
        }
        List sidIds = this.jdbcTemplate.queryForList(this.selectSidPrimaryKey, new Object[]{new Boolean(principal), sidName}, class$java$lang$Long == null ? (class$java$lang$Long = JdbcMutableAclService.class$("java.lang.Long")) : class$java$lang$Long);
        Long sidId = null;
        if (sidIds.isEmpty()) {
            if (allowCreate) {
                sidId = null;
                this.jdbcTemplate.update(this.insertSid, new Object[]{new Boolean(principal), sidName});
                Assert.isTrue((boolean)TransactionSynchronizationManager.isSynchronizationActive(), (String)"Transaction must be running");
                sidId = new Long(this.jdbcTemplate.queryForLong(this.sidIdentityQuery));
            }
        } else {
            sidId = (Long)sidIds.iterator().next();
        }
        return sidId;
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        ObjectIdentity[] children;
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)objectIdentity.getIdentifier(), (String)"Object Identity doesn't provide an identifier");
        if (deleteChildren) {
            children = this.findChildren(objectIdentity);
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    this.deleteAcl(children[i], true);
                }
            }
        } else if (!this.foreignKeysInDatabase && (children = this.findChildren(objectIdentity)) != null) {
            throw new ChildrenExistException("Cannot delete '" + objectIdentity + "' (has " + children.length + " children)");
        }
        Long oidPrimaryKey = this.retrieveObjectIdentityPrimaryKey(objectIdentity);
        this.deleteEntries(oidPrimaryKey);
        this.deleteObjectIdentity(oidPrimaryKey);
        this.aclCache.evictFromCache(objectIdentity);
    }

    protected void deleteEntries(Long oidPrimaryKey) {
        this.jdbcTemplate.update(this.deleteEntryByObjectIdentityForeignKey, new Object[]{oidPrimaryKey});
    }

    protected void deleteObjectIdentity(Long oidPrimaryKey) {
        this.jdbcTemplate.update(this.deleteObjectIdentityByPrimaryKey, new Object[]{oidPrimaryKey});
    }

    protected Long retrieveObjectIdentityPrimaryKey(ObjectIdentity oid) {
        try {
            return new Long(this.jdbcTemplate.queryForLong(this.selectObjectIdentityPrimaryKey, new Object[]{oid.getJavaType().getName(), oid.getIdentifier()}));
        }
        catch (DataAccessException notFound) {
            return null;
        }
    }

    public MutableAcl updateAcl(MutableAcl acl) throws NotFoundException {
        Assert.notNull((Object)acl.getId(), (String)"Object Identity doesn't provide an identifier");
        this.deleteEntries(this.retrieveObjectIdentityPrimaryKey(acl.getObjectIdentity()));
        this.createEntries(acl);
        this.updateObjectIdentity(acl);
        this.clearCacheIncludingChildren(acl.getObjectIdentity());
        return (MutableAcl)super.readAclById(acl.getObjectIdentity());
    }

    private void clearCacheIncludingChildren(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        ObjectIdentity[] children = this.findChildren(objectIdentity);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.clearCacheIncludingChildren(children[i]);
            }
        }
        this.aclCache.evictFromCache(objectIdentity);
    }

    protected void updateObjectIdentity(MutableAcl acl) {
        Long parentId = null;
        if (acl.getParentAcl() != null) {
            Assert.isInstanceOf((Class)(class$org$springframework$security$acls$objectidentity$ObjectIdentityImpl == null ? (class$org$springframework$security$acls$objectidentity$ObjectIdentityImpl = JdbcMutableAclService.class$("org.springframework.security.acls.objectidentity.ObjectIdentityImpl")) : class$org$springframework$security$acls$objectidentity$ObjectIdentityImpl), (Object)acl.getParentAcl().getObjectIdentity(), (String)"Implementation only supports ObjectIdentityImpl");
            ObjectIdentityImpl oii = (ObjectIdentityImpl)acl.getParentAcl().getObjectIdentity();
            parentId = this.retrieveObjectIdentityPrimaryKey(oii);
        }
        Assert.notNull((Object)acl.getOwner(), (String)"Owner is required in this implementation");
        Long ownerSid = this.createOrRetrieveSidPrimaryKey(acl.getOwner(), true);
        int count = this.jdbcTemplate.update(this.updateObjectIdentity, new Object[]{parentId, ownerSid, new Boolean(acl.isEntriesInheriting()), acl.getId()});
        if (count != 1) {
            throw new NotFoundException("Unable to locate ACL to update");
        }
    }

    public void setClassIdentityQuery(String identityQuery) {
        Assert.hasText((String)identityQuery, (String)"New identity query is required");
        this.classIdentityQuery = identityQuery;
    }

    public void setSidIdentityQuery(String identityQuery) {
        Assert.hasText((String)identityQuery, (String)"New identity query is required");
        this.sidIdentityQuery = identityQuery;
    }

    public void setForeignKeysInDatabase(boolean foreignKeysInDatabase) {
        this.foreignKeysInDatabase = foreignKeysInDatabase;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

