/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLAuthenticationToken;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.util.Assert;

public class SAMLProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    protected static final Logger logger = LoggerFactory.getLogger(SAMLProcessingFilter.class);
    protected SAMLProcessor processor;
    protected SAMLContextProvider contextProvider;
    private String filterProcessesUrl;
    public static final String FILTER_URL = "/saml/SSO";

    public SAMLProcessingFilter() {
        this(FILTER_URL);
    }

    protected SAMLProcessingFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        this.setFilterProcessesUrl(defaultFilterProcessesUrl);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            logger.debug("Attempting SAML2 authentication using profile {}", (Object)this.getProfileName());
            SAMLMessageContext context = this.contextProvider.getLocalEntity(request, response);
            this.processor.retrieveMessage(context);
            context.setCommunicationProfileId(this.getProfileName());
            context.setLocalEntityEndpoint((Endpoint)SAMLUtil.getEndpoint(context.getLocalEntityRoleMetadata().getEndpoints(), context.getInboundSAMLBinding(), context.getInboundMessageTransport()));
            SAMLAuthenticationToken token = new SAMLAuthenticationToken(context);
            return this.getAuthenticationManager().authenticate((Authentication)token);
        }
        catch (SAMLException e) {
            logger.debug("Incoming SAML message is invalid", (Throwable)e);
            throw new AuthenticationServiceException("Incoming SAML message is invalid", (Throwable)e);
        }
        catch (MetadataProviderException e) {
            logger.debug("Error determining metadata contracts", (Throwable)e);
            throw new AuthenticationServiceException("Error determining metadata contracts", (Throwable)e);
        }
        catch (MessageDecodingException e) {
            logger.debug("Error decoding incoming SAML message", (Throwable)e);
            throw new AuthenticationServiceException("Error decoding incoming SAML message", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.debug("Incoming SAML message is invalid", (Throwable)e);
            throw new AuthenticationServiceException("Incoming SAML message is invalid", (Throwable)e);
        }
    }

    protected String getProfileName() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return SAMLUtil.processFilter(this.getFilterProcessesUrl(), request);
    }

    @Deprecated
    public void setDefaultTargetUrl(String url) {
        SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
        handler.setDefaultTargetUrl(url);
        this.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)handler);
    }

    @Autowired
    public void setSAMLProcessor(SAMLProcessor processor) {
        Assert.notNull((Object)processor, (String)"SAML Processor can't be null");
        this.processor = processor;
    }

    @Autowired
    public void setContextProvider(SAMLContextProvider contextProvider) {
        Assert.notNull((Object)contextProvider, (String)"Context provider can't be null");
        this.contextProvider = contextProvider;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.processor, (String)"SAMLProcessor must be set");
        Assert.notNull((Object)this.contextProvider, (String)"Context provider must be set");
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
        super.setFilterProcessesUrl(filterProcessesUrl);
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }
}

