/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ClassUtils;

public class UUIDConverter
implements Converter<Object, UUID> {
    @Deprecated
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Pattern UUID_REGEX = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    public UUID convert(Object source) {
        return UUIDConverter.getUUID(source);
    }

    public static UUID getUUID(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof UUID) {
            return (UUID)input;
        }
        if (input instanceof String) {
            String inputText = (String)input;
            if (UUIDConverter.isValidUuidStringRepresentation(inputText)) {
                return UUID.fromString(inputText);
            }
            return UUIDConverter.fromStringBytes(inputText);
        }
        if (ClassUtils.isPrimitiveOrWrapper(input.getClass())) {
            return UUIDConverter.fromStringBytes(input.toString());
        }
        byte[] bytes = UUIDConverter.serialize(input);
        return UUID.nameUUIDFromBytes(bytes);
    }

    private static UUID fromStringBytes(String input) {
        return UUID.nameUUIDFromBytes(input.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(stream).writeObject(object);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not serialize object of type: " + object.getClass(), ex);
        }
        return stream.toByteArray();
    }

    private static boolean isValidUuidStringRepresentation(String uuid) {
        return UUID_REGEX.matcher(uuid).matches();
    }
}

