/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.dsl.PollerSpec;
import org.springframework.integration.dsl.Pollers;
import org.springframework.scheduling.Trigger;

public final class PollerFactory {
    public PollerSpec trigger(Trigger trigger2) {
        return Pollers.trigger(trigger2);
    }

    public PollerSpec cron(String cronExpression) {
        return Pollers.cron(cronExpression);
    }

    public PollerSpec cron(String cronExpression, TimeZone timeZone) {
        return Pollers.cron(cronExpression, timeZone);
    }

    public PollerSpec fixedRate(long period) {
        return Pollers.fixedRate(period);
    }

    @Deprecated(forRemoval=true)
    public PollerSpec fixedRate(long period, TimeUnit timeUnit) {
        return Pollers.fixedRate(Duration.of(period, timeUnit.toChronoUnit()));
    }

    public static PollerSpec fixedRate(Duration period) {
        return Pollers.fixedRate(period);
    }

    public PollerSpec fixedRate(long period, long initialDelay) {
        return Pollers.fixedRate(period, initialDelay);
    }

    public static PollerSpec fixedRate(Duration period, Duration initialDelay) {
        return Pollers.fixedRate(period, initialDelay);
    }

    @Deprecated(forRemoval=true)
    public PollerSpec fixedRate(long period, TimeUnit timeUnit, long initialDelay) {
        ChronoUnit chronoUnit = timeUnit.toChronoUnit();
        return Pollers.fixedRate(Duration.of(period, chronoUnit), Duration.of(initialDelay, chronoUnit));
    }

    @Deprecated(forRemoval=true)
    public PollerSpec fixedDelay(long period, TimeUnit timeUnit, long initialDelay) {
        ChronoUnit chronoUnit = timeUnit.toChronoUnit();
        return Pollers.fixedDelay(Duration.of(period, chronoUnit), Duration.of(initialDelay, chronoUnit));
    }

    @Deprecated(forRemoval=true)
    public PollerSpec fixedDelay(long period, TimeUnit timeUnit) {
        return Pollers.fixedDelay(Duration.of(period, timeUnit.toChronoUnit()));
    }

    public PollerSpec fixedDelay(long period, long initialDelay) {
        return Pollers.fixedDelay(period, initialDelay);
    }

    public PollerSpec fixedDelay(long period) {
        return Pollers.fixedDelay(period);
    }

    public static PollerSpec fixedDelay(Duration period) {
        return Pollers.fixedDelay(period);
    }

    public static PollerSpec fixedDelay(Duration period, Duration initialDelay) {
        return Pollers.fixedDelay(period, initialDelay);
    }

    PollerFactory() {
    }
}

