/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.springframework.integration.channel.PartitionedChannel;
import org.springframework.integration.dsl.LoadBalancingChannelSpec;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public class PartitionedChannelSpec
extends LoadBalancingChannelSpec<PartitionedChannelSpec, PartitionedChannel> {
    private final int partitionCount;
    @Nullable
    private Function<Message<?>, Object> partitionKeyFunction;
    @Nullable
    private ThreadFactory threadFactory;

    protected PartitionedChannelSpec(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public PartitionedChannelSpec partitionKey(Function<Message<?>, Object> partitionKeyFunction) {
        this.partitionKeyFunction = partitionKeyFunction;
        return this;
    }

    public PartitionedChannelSpec threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    @Override
    protected PartitionedChannel doGet() {
        this.channel = this.partitionKeyFunction != null ? new PartitionedChannel(this.partitionCount, this.partitionKeyFunction) : new PartitionedChannel(this.partitionCount);
        ((PartitionedChannel)this.channel).setLoadBalancingStrategy(this.loadBalancingStrategy);
        if (this.failover != null) {
            ((PartitionedChannel)this.channel).setFailover(this.failover);
        }
        if (this.maxSubscribers != null) {
            ((PartitionedChannel)this.channel).setMaxSubscribers(this.maxSubscribers);
        }
        if (this.threadFactory != null) {
            ((PartitionedChannel)this.channel).setThreadFactory(this.threadFactory);
        }
        return (PartitionedChannel)super.doGet();
    }
}

