/*
 * Copyright 2015-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.Message;

/**
 * Advice for a {@link MessageSource#receive()} method to decide whether a poll
 * should be ignored and/or take action after the receive.
 *
 * @author Gary Russell
 *
 * @since 4.2
 */
public abstract class AbstractMessageSourceAdvice implements MethodInterceptor, MessageSourceMutator {

	@Override
	public final Object invoke(MethodInvocation invocation) throws Throwable {
		Object target = invocation.getThis();
		if (!(target instanceof MessageSource)) {
			return invocation.proceed();
		}

		Message<?> result = null;
		if (beforeReceive((MessageSource<?>) target)) {
			result = (Message<?>) invocation.proceed();
		}
		return afterReceive(result, (MessageSource<?>) target);
	}

}
