/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test.mockito;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class LambdaAnswer<T>
implements Answer<T> {
    private final boolean callRealMethod;
    private final ValueToReturn<T> callback;
    private final Set<Exception> exceptions = Collections.synchronizedSet(new LinkedHashSet());

    public LambdaAnswer(boolean callRealMethod, ValueToReturn<T> callback) {
        this.callRealMethod = callRealMethod;
        this.callback = callback;
    }

    public T answer(InvocationOnMock invocation) throws Throwable {
        Object result = null;
        try {
            if (this.callRealMethod) {
                result = invocation.callRealMethod();
            }
            return (T)this.callback.apply(invocation, result);
        }
        catch (Exception e) {
            this.exceptions.add(e);
            throw e;
        }
    }

    public Collection<Exception> getExceptions() {
        return Collections.unmodifiableCollection(this.exceptions);
    }

    @FunctionalInterface
    public static interface ValueToReturn<T> {
        public T apply(InvocationOnMock var1, T var2);
    }
}

