/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.config;

import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.launch.server.ServerInfo;
import org.springblade.core.log.aspect.ApiLogAspect;
import org.springblade.core.log.event.ApiLogListener;
import org.springblade.core.log.event.ErrorLogListener;
import org.springblade.core.log.event.UsualLogListener;
import org.springblade.core.log.feign.ILogClient;
import org.springblade.core.log.logger.BladeLogger;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication
public class BladeLogToolAutoConfiguration {
    private final ILogClient logService;
    private final ServerInfo serverInfo;
    private final BladeProperties bladeProperties;

    @Bean
    public ApiLogAspect apiLogAspect() {
        return new ApiLogAspect();
    }

    @Bean
    public BladeLogger bladeLogger() {
        return new BladeLogger();
    }

    @Bean
    public ApiLogListener apiLogListener() {
        return new ApiLogListener(this.logService, this.serverInfo, this.bladeProperties);
    }

    @Bean
    public ErrorLogListener errorEventListener() {
        return new ErrorLogListener(this.logService, this.serverInfo, this.bladeProperties);
    }

    @Bean
    public UsualLogListener bladeEventListener() {
        return new UsualLogListener(this.logService, this.serverInfo, this.bladeProperties);
    }

    public BladeLogToolAutoConfiguration(ILogClient logService, ServerInfo serverInfo, BladeProperties bladeProperties) {
        this.logService = logService;
        this.serverInfo = serverInfo;
        this.bladeProperties = bladeProperties;
    }
}

