/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.tool.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.springaicommunity.mcp.annotation.McpMeta;
import org.springaicommunity.mcp.annotation.McpProgressToken;
import org.springaicommunity.mcp.annotation.McpToolParam;
import org.springaicommunity.mcp.method.tool.utils.ClassUtils;
import org.springaicommunity.mcp.method.tool.utils.ConcurrentReferenceHashMap;
import org.springaicommunity.mcp.method.tool.utils.JsonParser;
import org.springaicommunity.mcp.method.tool.utils.SpringAiSchemaModule;
import reactor.util.annotation.Nullable;

public class JsonSchemaGenerator {
    private static final boolean PROPERTY_REQUIRED_BY_DEFAULT = true;
    private static final SchemaGenerator TYPE_SCHEMA_GENERATOR;
    private static final SchemaGenerator SUBTYPE_SCHEMA_GENERATOR;
    private static final Map<Method, String> methodSchemaCache;
    private static final Map<Class<?>, String> classSchemaCache;

    public static String generateForMethodInput(Method method) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        return methodSchemaCache.computeIfAbsent(method, JsonSchemaGenerator::internalGenerateFromMethodArguments);
    }

    private static String internalGenerateFromMethodArguments(Method method) {
        boolean hasOtherParams;
        boolean hasCallToolRequestParam = Arrays.stream(method.getParameterTypes()).anyMatch(type -> McpSchema.CallToolRequest.class.isAssignableFrom((Class<?>)type));
        if (hasCallToolRequestParam && !(hasOtherParams = Arrays.stream(method.getParameters()).anyMatch(param -> {
            Class<?> type = param.getType();
            return !McpSchema.CallToolRequest.class.isAssignableFrom(type) && !McpSyncServerExchange.class.isAssignableFrom(type) && !McpAsyncServerExchange.class.isAssignableFrom(type) && !param.isAnnotationPresent(McpProgressToken.class) && !McpMeta.class.isAssignableFrom(type);
        }))) {
            ObjectNode schema = JsonParser.getObjectMapper().createObjectNode();
            schema.put("type", "object");
            schema.putObject("properties");
            schema.putArray("required");
            return schema.toPrettyString();
        }
        ObjectNode schema = JsonParser.getObjectMapper().createObjectNode();
        schema.put("$schema", SchemaVersion.DRAFT_2020_12.getIdentifier());
        schema.put("type", "object");
        ObjectNode properties = schema.putObject("properties");
        ArrayList<String> required = new ArrayList<String>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class parameterClass;
            Parameter parameter = method.getParameters()[i];
            String parameterName = parameter.getName();
            Type parameterType = method.getGenericParameterTypes()[i];
            if (parameter.isAnnotationPresent(McpProgressToken.class) || parameterType instanceof Class && McpMeta.class.isAssignableFrom(parameterClass = (Class)parameterType) || parameterType instanceof Class && (ClassUtils.isAssignable(McpSyncServerExchange.class, parameterClass = (Class)parameterType) || ClassUtils.isAssignable(McpAsyncServerExchange.class, parameterClass) || ClassUtils.isAssignable(McpSchema.CallToolRequest.class, parameterClass))) continue;
            if (JsonSchemaGenerator.isMethodParameterRequired(method, i)) {
                required.add(parameterName);
            }
            ObjectNode parameterNode = SUBTYPE_SCHEMA_GENERATOR.generateSchema(parameterType, new Type[0]);
            String parameterDescription = JsonSchemaGenerator.getMethodParameterDescription(method, i);
            if (Utils.hasText((String)parameterDescription)) {
                parameterNode.put("description", parameterDescription);
            }
            properties.set(parameterName, (JsonNode)parameterNode);
        }
        ArrayNode requiredArray = schema.putArray("required");
        required.forEach(arg_0 -> ((ArrayNode)requiredArray).add(arg_0));
        return schema.toPrettyString();
    }

    public static String generateFromClass(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz cannot be null");
        return classSchemaCache.computeIfAbsent(clazz, JsonSchemaGenerator::internalGenerateFromClass);
    }

    private static String internalGenerateFromClass(Class<?> clazz) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        SchemaGeneratorConfig config = configBuilder.with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).without(Option.FLATTENED_ENUMS_FROM_TOSTRING, new Option[0]).build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchema = generator.generateSchema(clazz, new Type[0]);
        return jsonSchema.toPrettyString();
    }

    public static boolean hasCallToolRequestParameter(Method method) {
        return Arrays.stream(method.getParameterTypes()).anyMatch(type -> McpSchema.CallToolRequest.class.isAssignableFrom((Class<?>)type));
    }

    private static boolean isMethodParameterRequired(Method method, int index) {
        Parameter parameter = method.getParameters()[index];
        McpToolParam toolParamAnnotation = parameter.getAnnotation(McpToolParam.class);
        if (toolParamAnnotation != null) {
            return toolParamAnnotation.required();
        }
        JsonProperty propertyAnnotation = parameter.getAnnotation(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.required();
        }
        Schema schemaAnnotation = parameter.getAnnotation(Schema.class);
        if (schemaAnnotation != null) {
            return schemaAnnotation.requiredMode() == Schema.RequiredMode.REQUIRED || schemaAnnotation.requiredMode() == Schema.RequiredMode.AUTO || schemaAnnotation.required();
        }
        Nullable nullableAnnotation = parameter.getAnnotation(Nullable.class);
        return nullableAnnotation == null;
    }

    private static String getMethodParameterDescription(Method method, int index) {
        Parameter parameter = method.getParameters()[index];
        McpToolParam toolParamAnnotation = parameter.getAnnotation(McpToolParam.class);
        if (toolParamAnnotation != null && Utils.hasText((String)toolParamAnnotation.description())) {
            return toolParamAnnotation.description();
        }
        JsonPropertyDescription jacksonAnnotation = parameter.getAnnotation(JsonPropertyDescription.class);
        if (jacksonAnnotation != null && Utils.hasText((String)jacksonAnnotation.value())) {
            return jacksonAnnotation.value();
        }
        Schema schemaAnnotation = parameter.getAnnotation(Schema.class);
        if (schemaAnnotation != null && Utils.hasText((String)schemaAnnotation.description())) {
            return schemaAnnotation.description();
        }
        return null;
    }

    static {
        methodSchemaCache = new ConcurrentReferenceHashMap<Method, String>(256);
        classSchemaCache = new ConcurrentReferenceHashMap(256);
        JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED});
        Swagger2Module openApiModule = new Swagger2Module();
        SpringAiSchemaModule springAiSchemaModule = new SpringAiSchemaModule(new SpringAiSchemaModule.Option[0]);
        SchemaGeneratorConfigBuilder schemaGeneratorConfigBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule).with((Module)openApiModule).with((Module)springAiSchemaModule).with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).with(Option.STANDARD_FORMATS, new Option[0]).with(Option.PLAIN_DEFINITION_KEYS, new Option[0]);
        SchemaGeneratorConfig typeSchemaGeneratorConfig = schemaGeneratorConfigBuilder.build();
        TYPE_SCHEMA_GENERATOR = new SchemaGenerator(typeSchemaGeneratorConfig);
        SchemaGeneratorConfig subtypeSchemaGeneratorConfig = schemaGeneratorConfigBuilder.without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]).build();
        SUBTYPE_SCHEMA_GENERATOR = new SchemaGenerator(subtypeSchemaGeneratorConfig);
    }
}

