/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v97.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v97.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SubresourceWebBundleInnerResponseError {
    private final RequestId innerRequestId;
    private final String innerRequestURL;
    private final String errorMessage;
    private final Optional<RequestId> bundleRequestId;

    public SubresourceWebBundleInnerResponseError(RequestId innerRequestId, String innerRequestURL, String errorMessage, Optional<RequestId> bundleRequestId) {
        this.innerRequestId = Objects.requireNonNull(innerRequestId, "innerRequestId is required");
        this.innerRequestURL = Objects.requireNonNull(innerRequestURL, "innerRequestURL is required");
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage is required");
        this.bundleRequestId = bundleRequestId;
    }

    public RequestId getInnerRequestId() {
        return this.innerRequestId;
    }

    public String getInnerRequestURL() {
        return this.innerRequestURL;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Optional<RequestId> getBundleRequestId() {
        return this.bundleRequestId;
    }

    private static SubresourceWebBundleInnerResponseError fromJson(JsonInput input) {
        RequestId innerRequestId = null;
        String innerRequestURL = null;
        String errorMessage = null;
        Optional<RequestId> bundleRequestId = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "innerRequestId": {
                    innerRequestId = (RequestId)input.read(RequestId.class);
                    continue block12;
                }
                case "innerRequestURL": {
                    innerRequestURL = input.nextString();
                    continue block12;
                }
                case "errorMessage": {
                    errorMessage = input.nextString();
                    continue block12;
                }
                case "bundleRequestId": {
                    bundleRequestId = Optional.ofNullable((RequestId)input.read(RequestId.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SubresourceWebBundleInnerResponseError(innerRequestId, innerRequestURL, errorMessage, bundleRequestId);
    }
}

