/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.exception.TaskException;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.StreamTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.validation.constraint.ValidSingleOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleOutputValidator
implements ConstraintValidator<ValidSingleOutput, SingleOutputTaskParameters> {
    public void initialize(ValidSingleOutput constraintAnnotation) {
    }

    public boolean isValid(SingleOutputTaskParameters value, ConstraintValidatorContext context) {
        if (value != null && value.getOutput() != null) {
            return this.isValidOutputType(value);
        }
        return true;
    }

    private boolean isValidOutputType(SingleOutputTaskParameters value) {
        OutputNameValidatorDispatcher dispatcher = new OutputNameValidatorDispatcher(value.getOutputName());
        try {
            value.getOutput().accept(dispatcher);
        }
        catch (TaskException e) {
            throw new SejdaRuntimeException(e);
        }
        return dispatcher.isValid();
    }

    private static class OutputNameValidatorDispatcher
    implements TaskOutputDispatcher {
        private boolean valid = true;
        private String outputName;

        OutputNameValidatorDispatcher(String outputName) {
            this.outputName = outputName;
        }

        public void dispatch(FileTaskOutput output) {
            this.valid = true;
        }

        public void dispatch(DirectoryTaskOutput output) {
            this.valid = StringUtils.isNotBlank((CharSequence)this.outputName);
        }

        public void dispatch(StreamTaskOutput output) {
            this.valid = StringUtils.isNotBlank((CharSequence)this.outputName);
        }

        boolean isValid() {
            return this.valid;
        }
    }
}

