/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.exception.TaskException;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.StreamTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleOutputExtensionsValidator
implements ConstraintValidator<SingleOutputAllowedExtensions, SingleOutputTaskParameters> {
    private String[] extensions;

    public void initialize(SingleOutputAllowedExtensions constraintAnnotation) {
        this.extensions = constraintAnnotation.extensions();
    }

    public boolean isValid(SingleOutputTaskParameters value, ConstraintValidatorContext context) {
        if (value != null && value.getOutput() != null && ArrayUtils.isNotEmpty((Object[])this.extensions)) {
            String fileName = this.getOutputFileName(value);
            if (this.hasAllowedExtension(fileName)) {
                return true;
            }
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("The output '%s' is not one of the expected types: %s", fileName, ArrayUtils.toString((Object)this.extensions))).addNode("taskOutput").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean hasAllowedExtension(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        for (String current : this.extensions) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)current, (CharSequence)extension) || FilenameUtils.indexOfExtension((String)fileName) <= 0) continue;
            return true;
        }
        return false;
    }

    private String getOutputFileName(SingleOutputTaskParameters value) {
        NameRetriever retriever = new NameRetriever(value.getOutputName());
        try {
            value.getOutput().accept(retriever);
        }
        catch (TaskException e) {
            throw new SejdaRuntimeException(e);
        }
        return retriever.getOutputName();
    }

    private static final class NameRetriever
    implements TaskOutputDispatcher {
        private String outputName;

        private NameRetriever(String outputName) {
            this.outputName = outputName;
        }

        public void dispatch(FileTaskOutput output) {
            this.outputName = output.getDestination().getName();
        }

        public void dispatch(DirectoryTaskOutput output) {
        }

        public void dispatch(StreamTaskOutput output) {
        }

        String getOutputName() {
            return this.outputName;
        }
    }
}

