/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import java.util.ArrayList;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.validation.constraint.NoIntersections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoIntersectionsValidator
implements ConstraintValidator<NoIntersections, PageRangeSelection> {
    public void initialize(NoIntersections constraintAnnotation) {
    }

    public boolean isValid(PageRangeSelection value, ConstraintValidatorContext context) {
        if (value != null) {
            ArrayList<PageRange> ranges = new ArrayList<PageRange>(value.getPageSelection());
            for (int i = 0; i < ranges.size(); ++i) {
                PageRange range = (PageRange)ranges.get(i);
                for (int j = i + 1; j < ranges.size(); ++j) {
                    PageRange current = (PageRange)ranges.get(j);
                    if (!range.intersects(current)) continue;
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(String.format("Invalid page ranges, found an intersection between %s and %s", range, current)).addNode("page ranges").addConstraintViolation();
                    return false;
                }
            }
        }
        return true;
    }
}

