/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.task;

import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.sejda.model.task.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifiableTaskMetadata
implements Serializable {
    private static final long serialVersionUID = -6423865557633949211L;
    public static final NotifiableTaskMetadata NULL = new NullNotifiableTaskMetadata();
    private UUID taskIdentifier;
    private String qualifiedName;

    private NotifiableTaskMetadata() {
    }

    public NotifiableTaskMetadata(Task<?> task) {
        if (task == null) {
            throw new IllegalArgumentException("No task given, unable to create notifiable metadata.");
        }
        this.taskIdentifier = UUID.randomUUID();
        this.qualifiedName = task.getClass().getName();
    }

    public UUID getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.taskIdentifier).append((Object)this.qualifiedName).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotifiableTaskMetadata)) {
            return false;
        }
        NotifiableTaskMetadata meta = (NotifiableTaskMetadata)other;
        return new EqualsBuilder().append((Object)this.taskIdentifier, (Object)meta.taskIdentifier).append((Object)this.qualifiedName, (Object)meta.qualifiedName).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("taskIdentifier", (Object)this.taskIdentifier).append("qualifiedName", (Object)this.qualifiedName).toString();
    }

    private static class NullNotifiableTaskMetadata
    extends NotifiableTaskMetadata {
        private static final long serialVersionUID = 6788562820506828221L;

        private NullNotifiableTaskMetadata() {
        }

        public UUID getTaskIdentifier() {
            return null;
        }

        public String getQualifiedName() {
            return "";
        }
    }
}

