/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.split;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.split.NextOutputStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitPages
implements NextOutputStrategy {
    private Set<Integer> closingPages = new HashSet<Integer>();
    private Set<Integer> openingPages = new HashSet<Integer>();

    public SplitPages(Collection<Integer> pages) {
        this(pages.toArray(new Integer[pages.size()]));
    }

    public SplitPages(Integer ... pages) {
        this.openingPages.add(1);
        for (Integer page : pages) {
            this.add(page);
        }
    }

    void add(Integer page) {
        this.closingPages.add(page);
        this.openingPages.add(page + 1);
    }

    @Override
    public void ensureIsValid() throws TaskExecutionException {
        if (this.closingPages.isEmpty()) {
            throw new TaskExecutionException("Unable to split, no page number given.");
        }
    }

    @Override
    public boolean isOpening(Integer page) {
        return this.openingPages.contains(page);
    }

    @Override
    public boolean isClosing(Integer page) {
        return this.closingPages.contains(page);
    }
}

