/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.transition;

import java.security.InvalidParameterException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.pdf.transition.PdfPageTransitionStyle;

public final class PdfPageTransition {
    @NotNull
    private PdfPageTransitionStyle style;
    @Min(value=1L)
    private int transitionDuration;
    @Min(value=1L)
    private int displayDuration;

    private PdfPageTransition(PdfPageTransitionStyle style, int transitionDuration, int displayDuration) {
        this.style = style;
        this.transitionDuration = transitionDuration;
        this.displayDuration = displayDuration;
    }

    public PdfPageTransitionStyle getStyle() {
        return this.style;
    }

    public int getTransitionDuration() {
        return this.transitionDuration;
    }

    public int getDisplayDuration() {
        return this.displayDuration;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.style).append("transitionDuration", this.transitionDuration).append("displayDuration", this.displayDuration).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.style).append(this.transitionDuration).append(this.displayDuration).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PdfPageTransition)) {
            return false;
        }
        PdfPageTransition transition = (PdfPageTransition)other;
        return new EqualsBuilder().append((Object)this.style, (Object)transition.getStyle()).append(this.transitionDuration, transition.getTransitionDuration()).append(this.displayDuration, transition.getDisplayDuration()).isEquals();
    }

    public static PdfPageTransition newInstance(PdfPageTransitionStyle style, int transitionDuration, int displayDuration) {
        if (transitionDuration < 1) {
            throw new InvalidParameterException("Input transition duration must be positive.");
        }
        if (displayDuration < 1) {
            throw new InvalidParameterException("Input display duration must be positive.");
        }
        if (style == null) {
            throw new InvalidParameterException("Input style cannot be null.");
        }
        return new PdfPageTransition(style, transitionDuration, displayDuration);
    }
}

