/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.page;

import java.util.SortedSet;
import java.util.TreeSet;
import org.sejda.common.FriendlyNamed;
import org.sejda.model.pdf.page.PagesSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PredefinedSetOfPages implements PagesSelection,
FriendlyNamed
{
    ALL_PAGES("all"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            TreeSet<Integer> retSet = new TreeSet<Integer>();
            for (int i = 1; i <= totalNumberOfPage; ++i) {
                retSet.add(i);
            }
            return retSet;
        }
    }
    ,
    EVEN_PAGES("even"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            TreeSet<Integer> retSet = new TreeSet<Integer>();
            for (int i = 2; i <= totalNumberOfPage; i += 2) {
                retSet.add(i);
            }
            return retSet;
        }
    }
    ,
    ODD_PAGES("odd"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            TreeSet<Integer> retSet = new TreeSet<Integer>();
            for (int i = 1; i <= totalNumberOfPage; i += 2) {
                retSet.add(i);
            }
            return retSet;
        }
    }
    ,
    NONE("none"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            return new TreeSet<Integer>();
        }
    };

    private String displayName;

    public abstract SortedSet<Integer> getPages(int var1);

    private PredefinedSetOfPages(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getFriendlyName() {
        return this.displayName;
    }
}

