/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.headerfooter;

import org.sejda.common.FriendlyNamed;
import org.sejda.common.RomanNumbersUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NumberingStyle implements FriendlyNamed
{
    ARABIC("arabic"){

        public String toStyledString(int number) {
            return Integer.toString(number);
        }
    }
    ,
    EMPTY("empty"){

        public String toStyledString(int number) {
            return "";
        }
    }
    ,
    ROMAN("roman"){

        public String toStyledString(int number) {
            return RomanNumbersUtils.toRoman(number);
        }
    };

    private String displayName;

    private NumberingStyle(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getFriendlyName() {
        return this.displayName;
    }

    public abstract String toStyledString(int var1);
}

