/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter.image;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.image.ImageColorType;
import org.sejda.model.output.MultipleTaskOutput;
import org.sejda.model.parameter.base.MultipleOutputTaskParameters;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPdfToMultipleImageParameters
extends AbstractPdfToImageParameters
implements MultipleOutputTaskParameters,
PageRangeSelection,
PagesSelection {
    private String outputPrefix = "";
    @Valid
    @NotNull
    private MultipleTaskOutput<?> output;
    @Valid
    private final Set<PageRange> pageSelection = new NullSafeSet<PageRange>();

    AbstractPdfToMultipleImageParameters(ImageColorType outputImageColorType) {
        super(outputImageColorType);
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection);
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        if (this.pageSelection.isEmpty()) {
            return PredefinedSetOfPages.ALL_PAGES.getPages(upperLimit);
        }
        NullSafeSet<Integer> retSet = new NullSafeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(upperLimit));
        }
        return retSet;
    }

    @Override
    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    @Override
    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public MultipleTaskOutput<?> getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(MultipleTaskOutput<?> output) {
        this.output = output;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.output).append((Object)this.outputPrefix).append(this.pageSelection).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractPdfToMultipleImageParameters)) {
            return false;
        }
        AbstractPdfToMultipleImageParameters parameter = (AbstractPdfToMultipleImageParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.output, (Object)parameter.getOutput()).append((Object)this.outputPrefix, (Object)parameter.getOutputPrefix()).append(this.pageSelection, parameter.pageSelection).isEquals();
    }
}

