/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.MinRequiredVersion;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.model.pdf.viewerpreference.PdfBooleanPreference;
import org.sejda.model.pdf.viewerpreference.PdfDirection;
import org.sejda.model.pdf.viewerpreference.PdfDuplex;
import org.sejda.model.pdf.viewerpreference.PdfNonFullScreenPageMode;
import org.sejda.model.pdf.viewerpreference.PdfPageLayout;
import org.sejda.model.pdf.viewerpreference.PdfPageMode;
import org.sejda.model.pdf.viewerpreference.PdfPrintScaling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerPreferencesParameters
extends MultiplePdfSourceMultipleOutputParameters {
    @NotNull
    private PdfPageMode pageMode = PdfPageMode.USE_NONE;
    @NotNull
    private PdfPageLayout pageLayout = PdfPageLayout.SINGLE_PAGE;
    @NotNull
    private PdfNonFullScreenPageMode nfsMode = PdfNonFullScreenPageMode.USE_NONE;
    private PdfDuplex duplex;
    private PdfDirection direction;
    private PdfPrintScaling printScaling;
    private Set<PdfBooleanPreference> enabledBooleanPreferences = EnumSet.noneOf(PdfBooleanPreference.class);

    public boolean addEnabledPreference(PdfBooleanPreference e) {
        return this.enabledBooleanPreferences.add(e);
    }

    public void clearEnabledPreferences() {
        this.enabledBooleanPreferences.clear();
    }

    public PdfPageMode getPageMode() {
        return this.pageMode;
    }

    public void setPageMode(PdfPageMode pageMode) {
        this.pageMode = pageMode;
    }

    public PdfPageLayout getPageLayout() {
        return this.pageLayout;
    }

    public void setPageLayout(PdfPageLayout pageLayout) {
        this.pageLayout = pageLayout;
    }

    public PdfNonFullScreenPageMode getNfsMode() {
        return this.nfsMode;
    }

    public void setNfsMode(PdfNonFullScreenPageMode nfsMode) {
        this.nfsMode = nfsMode;
    }

    public PdfDuplex getDuplex() {
        return this.duplex;
    }

    public void setDuplex(PdfDuplex duplex) {
        this.duplex = duplex;
    }

    public PdfDirection getDirection() {
        return this.direction;
    }

    public void setDirection(PdfDirection direction) {
        this.direction = direction;
    }

    public PdfPrintScaling getPrintScaling() {
        return this.printScaling;
    }

    public void setPrintScaling(PdfPrintScaling printScaling) {
        this.printScaling = printScaling;
    }

    public Set<PdfBooleanPreference> getEnabledPreferences() {
        return Collections.unmodifiableSet(this.enabledBooleanPreferences);
    }

    @Override
    public PdfVersion getMinRequiredPdfVersion() {
        return PdfVersion.getMax(super.getMinRequiredPdfVersion(), PdfVersion.getMax(this.printScaling, this.direction, this.duplex, this.pageLayout, this.pageMode), PdfVersion.getMax(this.enabledBooleanPreferences.toArray(new MinRequiredVersion[this.enabledBooleanPreferences.size()])));
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.printScaling).append((Object)this.direction).append((Object)this.duplex).append((Object)this.pageLayout).append((Object)this.pageMode).append((Object)this.nfsMode).append(this.enabledBooleanPreferences).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ViewerPreferencesParameters)) {
            return false;
        }
        ViewerPreferencesParameters parameter = (ViewerPreferencesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.printScaling, (Object)parameter.getPrintScaling()).append((Object)this.direction, (Object)parameter.getDirection()).append((Object)this.duplex, (Object)parameter.getDuplex()).append((Object)this.pageLayout, (Object)parameter.getPageLayout()).append((Object)this.pageMode, (Object)parameter.getPageMode()).append((Object)this.nfsMode, (Object)parameter.getNfsMode()).append(this.enabledBooleanPreferences, parameter.getEnabledPreferences()).isEquals();
    }
}

