/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.math.BigDecimal;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.parameter.base.SinglePdfSourceSingleOutputParameters;
import org.sejda.model.pdf.StandardType1Font;
import org.sejda.model.pdf.headerfooter.Numbering;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.validation.constraint.HasHeaderFooterDefinition;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

@SingleOutputAllowedExtensions
@HasHeaderFooterDefinition
public class SetHeaderFooterParameters
extends SinglePdfSourceSingleOutputParameters {
    @NotNull
    @Valid
    private PageRange pageRange;
    private StandardType1Font font = StandardType1Font.HELVETICA;
    private HorizontalAlign horizontalAlign = HorizontalAlign.CENTER;
    private VerticalAlign verticalAlign = VerticalAlign.BOTTOM;
    @Min(value=1L)
    private BigDecimal fontSize = BigDecimal.TEN;
    @NotNull
    @Valid
    private Numbering numbering = Numbering.NULL;
    private String labelPrefix;

    public PageRange getPageRange() {
        return this.pageRange;
    }

    public void setPageRange(PageRange pageRange) {
        this.pageRange = pageRange;
    }

    public String styledLabelFor(int pageNumber) {
        return String.format("%s%s", StringUtils.defaultString((String)this.labelPrefix, (String)""), this.numbering.styledLabelFor(pageNumber)).trim();
    }

    public StandardType1Font getFont() {
        return this.font;
    }

    public void setFont(StandardType1Font font) {
        this.font = font;
    }

    public HorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(HorizontalAlign align) {
        this.horizontalAlign = align;
    }

    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public BigDecimal getFontSize() {
        return this.fontSize;
    }

    public Numbering getNumbering() {
        return this.numbering;
    }

    public void setNumbering(Numbering numbering) {
        this.numbering = numbering == null ? Numbering.NULL : numbering;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setFontSize(BigDecimal fontSize) {
        this.fontSize = fontSize;
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.font).append((Object)this.horizontalAlign).append((Object)this.verticalAlign).append((Object)this.fontSize).append((Object)this.pageRange).append((Object)this.numbering).append((Object)this.labelPrefix).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetHeaderFooterParameters)) {
            return false;
        }
        SetHeaderFooterParameters parameter = (SetHeaderFooterParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getFont(), (Object)parameter.getFont()).append((Object)this.getHorizontalAlign(), (Object)parameter.getHorizontalAlign()).append((Object)this.getVerticalAlign(), (Object)parameter.getVerticalAlign()).append((Object)this.getFontSize(), (Object)parameter.getFontSize()).append((Object)this.getPageRange(), (Object)parameter.getPageRange()).append((Object)this.numbering, (Object)parameter.getNumbering()).append((Object)this.labelPrefix, (Object)parameter.getLabelPrefix()).isEquals();
    }
}

