/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.validation.constraint.NotEmpty;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SingleOutputAllowedExtensions
public class MergeParameters
extends AbstractPdfOutputParameters
implements SingleOutputTaskParameters {
    @NotEmpty
    @Valid
    private List<PdfMergeInput> inputList = new ArrayList<PdfMergeInput>();
    private boolean copyFormFields = false;
    private boolean blankPageIfOdd = false;
    @NotNull
    private OutlinePolicy outlinePolicy = OutlinePolicy.RETAIN;
    private String outputName;
    @Valid
    @NotNull
    private SingleTaskOutput<?> output;

    public SingleTaskOutput<?> getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(SingleTaskOutput<?> output) {
        this.output = output;
    }

    public List<PdfMergeInput> getInputList() {
        return Collections.unmodifiableList(this.inputList);
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public void addInput(PdfMergeInput input) {
        this.inputList.add(input);
    }

    public boolean isCopyFormFields() {
        return this.copyFormFields;
    }

    public boolean isBlankPageIfOdd() {
        return this.blankPageIfOdd;
    }

    public void setBlankPageIfOdd(boolean blankPageIfOdd) {
        this.blankPageIfOdd = blankPageIfOdd;
    }

    public void setCopyFormFields(boolean copyFormFields) {
        this.copyFormFields = copyFormFields;
    }

    public OutlinePolicy getOutlinePolicy() {
        return this.outlinePolicy;
    }

    public void setOutlinePolicy(OutlinePolicy outlinePolicy) {
        this.outlinePolicy = outlinePolicy;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.inputList).append(this.copyFormFields).append(this.blankPageIfOdd).append((Object)this.outlinePolicy).append((Object)this.outputName).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MergeParameters)) {
            return false;
        }
        MergeParameters parameter = (MergeParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.inputList, parameter.getInputList()).append(this.copyFormFields, parameter.isCopyFormFields()).append(this.blankPageIfOdd, parameter.isBlankPageIfOdd()).append((Object)this.outlinePolicy, (Object)parameter.getOutlinePolicy()).append((Object)this.outputName, (Object)parameter.getOutputName()).isEquals();
    }
}

