/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.input.PdfSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfMixInput {
    @NotNull
    @Valid
    private PdfSource<?> source;
    private boolean reverse = false;
    @Min(value=1L)
    private int step = 1;

    PdfMixInput() {
    }

    public PdfMixInput(PdfSource<?> source, boolean reverse, int step) {
        this.source = source;
        this.reverse = reverse;
        this.step = step;
    }

    public PdfMixInput(PdfSource<?> source) {
        this.source = source;
    }

    public PdfSource<?> getSource() {
        return this.source;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public int getStep() {
        return this.step;
    }

    public PdfMixInputProcessStatus newProcessingStatus(int numberOfPages) {
        return new PdfMixInputProcessStatus(numberOfPages);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.source).append(this.reverse).append(this.step).toString();
    }

    public final class PdfMixInputProcessStatus {
        private int currentPage;
        private int numberOfPages;

        private PdfMixInputProcessStatus(int numberOfPages) {
            this.numberOfPages = numberOfPages;
            this.currentPage = PdfMixInput.this.reverse ? numberOfPages : 1;
        }

        public int nextPage() {
            int retVal = this.currentPage--;
            if (!PdfMixInput.this.reverse) {
                ++this.currentPage;
            }
            return retVal;
        }

        public boolean hasNextPage() {
            return this.currentPage > 0 && this.currentPage <= this.numberOfPages;
        }
    }
}

