/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.input.PdfSource;
import org.sejda.model.validation.constraint.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPdfSource<T>
implements PdfSource<T> {
    private String password;
    @NotEmpty
    private final String name;

    public AbstractPdfSource(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("A not blank name are expected.");
        }
        this.name = name;
    }

    public AbstractPdfSource(String name, String password) {
        this(name);
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public byte[] getPasswordBytes() {
        byte[] retVal = null;
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            retVal = this.password.getBytes();
        }
        return retVal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).toString();
    }
}

