/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.image;

import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImageType {
    PNG("image/png", "png", false),
    JPEG("image/jpeg", "jpg", false),
    GIF("image/gif", "gif", true),
    TIFF("image/tiff", "tif", true);

    private String mimeType;
    private String extension;
    private boolean supportMultiImage;

    private ImageType(String mimeType, String extension, boolean supportMultiImage) {
        this.mimeType = mimeType;
        this.extension = extension;
        this.supportMultiImage = supportMultiImage;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isSupportMultiImage() {
        return this.supportMultiImage;
    }

    public String getExtension() {
        return this.extension;
    }

    public static Set<ImageType> valuesSupportingMultipleImage() {
        EnumSet<ImageType> retSet = EnumSet.noneOf(ImageType.class);
        for (ImageType current : ImageType.values()) {
            if (!current.isSupportMultiImage()) continue;
            retSet.add(current);
        }
        return retSet;
    }
}

