/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.xmlgraphics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.sejda.core.writer.xmlgraphics.AbstractImageWriterAdapter;
import org.sejda.model.image.TiffCompressionType;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseTiffImageWriterAdapter<T extends AbstractPdfToImageParameters>
extends AbstractImageWriterAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTiffImageWriterAdapter.class);
    private static final Map<TiffCompressionType, String> TIFF_COMPRESSION_TYPE_CACHE;

    BaseTiffImageWriterAdapter() {
    }

    ImageWriterParams newImageWriterParams(T params, TiffCompressionType compressionType) {
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        imageWriterParams.setResolution(params.getResolutionInDpi());
        String compression = TIFF_COMPRESSION_TYPE_CACHE.get(compressionType);
        if (StringUtils.isNotBlank((CharSequence)compression)) {
            imageWriterParams.setCompressionMethod(compression);
        } else {
            LOG.warn("{} compression type is currently not supported by XML Graphics.", (Object)compressionType);
        }
        return imageWriterParams;
    }

    static {
        HashMap<TiffCompressionType, String> compressionTypesCache = new HashMap<TiffCompressionType, String>();
        compressionTypesCache.put(TiffCompressionType.PACKBITS, "PackBits");
        compressionTypesCache.put(TiffCompressionType.NONE, "NONE");
        compressionTypesCache.put(TiffCompressionType.JPEG_TTN2, "JPEG");
        compressionTypesCache.put(TiffCompressionType.DEFLATE, "Deflate");
        TIFF_COMPRESSION_TYPE_CACHE = Collections.unmodifiableMap(compressionTypesCache);
    }
}

