/*
 * Created on 19/giu/2010
 *
 * Copyright 2010 by Andrea Vacondio (andrea.vacondio@gmail.com).
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 */
package org.sejda.core.support.io.model;

import java.io.File;

/**
 * Holds informations about an output file generated by a task. When fully populated holds a reference to the temporary file created by the task and information about the new name
 * for the temporary file. Usage:
 * 
 * <pre>
 * {
 *     PopulatedFileOutput out = file(tmpFile).name(outName);
 * }
 * </pre>
 * 
 * @author Andrea Vacondio
 * 
 */
public final class FileOutput implements OngoingFileOuputCreation, PopulatedFileOutput {

    private File file;
    private String name;

    private FileOutput(File file) {
        this.file = file;
    }

    /**
     * Entry point to populate the {@link FileOutput}
     * 
     * @param file
     * @return the not fully populated instance
     */
    public static OngoingFileOuputCreation file(File file) {
        return new FileOutput(file);
    }

    public File getFile() {
        return file;
    }

    public String getName() {
        return name;
    }

    public PopulatedFileOutput name(String name) {
        this.name = name;
        return this;
    }
}
