/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.NetUtil;
import io.netty.util.Timeout;
import io.netty.util.internal.StringUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAuthRequiredException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SentinelServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<RedisURI> sentinelHosts = new HashSet<RedisURI>();
    private final ConcurrentMap<RedisURI, RedisClient> sentinels = new ConcurrentHashMap<RedisURI, RedisClient>();
    private final AtomicReference<RedisURI> currentMaster = new AtomicReference();
    private volatile Timeout monitorFuture;
    private final Set<RedisURI> disconnectedSentinels = Collections.newSetFromMap(new ConcurrentHashMap());
    private RedisStrictCommand<RedisURI> masterHostCommand;
    private boolean usePassword = false;
    private String scheme;
    private SentinelServersConfig cfg;

    public SentinelConnectionManager(SentinelServersConfig cfg, Config configCopy) {
        super(cfg, configCopy);
        this.serviceManager.setNatMapper(cfg.getNatMapper());
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            this.scheme = addr.getScheme();
            if (NetUtil.createByteArrayFromIpAddressString((String)(addr = this.applyNatMap(addr)).getHost()) != null || addr.getHost().equals("localhost")) continue;
            this.sentinelHosts.add(addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doConnect(Set<RedisURI> disconnectedSlaves, Function<RedisURI, String> hostnameMapper) {
        this.checkAuth(this.cfg);
        this.masterHostCommand = "redis".equals(this.scheme) ? RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME : RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME_SSL;
        HashMap<RedisURI, Object> uri2hostname = new HashMap<RedisURI, Object>();
        Throwable lastException = null;
        for (String address : this.cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisConnection connection = null;
                try {
                    connection = client.connect();
                    if (!connection.isActive()) continue;
                }
                catch (RedisConnectionException e) {}
                continue;
                RedisURI master = connection.sync(this.masterHostCommand, this.cfg.getMasterName());
                if (master == null) {
                    throw new RedisConnectionException("Master node is undefined! SENTINEL GET-MASTER-ADDR-BY-NAME command returns empty result!");
                }
                InetSocketAddress masterHost = this.resolveIP(master.getHost(), String.valueOf(master.getPort())).join();
                RedisURI masterUri = this.toURI(masterHost);
                if (!master.isIP()) {
                    uri2hostname.put(masterUri, master.getHost());
                }
                this.config.setMasterAddress(masterUri.toString());
                this.currentMaster.set(masterUri);
                this.log.info("master: {} added", (Object)masterHost);
                List sentinelSlaves = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, this.cfg.getMasterName());
                for (Map map : sentinelSlaves) {
                    if (map.isEmpty()) continue;
                    String host = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String flags = map.getOrDefault("flags", "");
                    String masterLinkStatus = map.getOrDefault("master-link-status", "");
                    InetSocketAddress slaveAddr = this.resolveIP(host, port).join();
                    RedisURI uri = this.toURI(slaveAddr);
                    if (SentinelConnectionManager.isHostname(host)) {
                        uri2hostname.put(uri, host);
                    }
                    this.config.addSlaveAddress(uri.toString());
                    this.log.debug("slave {} state: {}", (Object)slaveAddr, (Object)map);
                    this.log.info("slave: {} added", (Object)slaveAddr);
                    if (!this.isSlaveDown(flags, masterLinkStatus)) continue;
                    disconnectedSlaves.add(uri);
                    this.log.warn("slave: {} is down", (Object)slaveAddr);
                }
                List sentinelSentinels = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, this.cfg.getMasterName());
                ArrayList<CompletableFuture<Void>> connectionFutures = new ArrayList<CompletableFuture<Void>>(sentinelSentinels.size());
                for (Map map : sentinelSentinels) {
                    if (map.isEmpty()) continue;
                    String ip = (String)map.get("ip");
                    String port = (String)map.get("port");
                    InetSocketAddress sentinelAddr = this.resolveIP(ip, port).join();
                    CompletionStage<Void> future = this.registerSentinel(sentinelAddr);
                    connectionFutures.add(future.toCompletableFuture());
                }
                CompletionStage<Void> f = this.registerSentinel(connection.getRedisClient().getAddr());
                connectionFutures.add(f.toCompletableFuture());
                CompletableFuture<Void> future = CompletableFuture.allOf(connectionFutures.toArray(new CompletableFuture[0]));
                try {
                    future.get(this.config.getConnectTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                break;
            }
            catch (RedisConnectionException e) {
                this.internalShutdown();
                throw e;
            }
            catch (Exception e) {
                if (e instanceof CompletionException) {
                    e = (Exception)e.getCause();
                }
                lastException = e;
                this.log.warn(e.getMessage());
            }
            finally {
                client.shutdownAsync();
            }
        }
        if (this.cfg.isCheckSentinelsList() && this.cfg.isSentinelsDiscovery()) {
            if (this.sentinels.isEmpty()) {
                this.internalShutdown();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns empty result or connection can't be established to some of them! Set checkSentinelsList = false to avoid this check.", lastException);
            }
            if (this.sentinels.size() < 2) {
                this.internalShutdown();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns less than 2 nodes or connection can't be established to some of them! At least two sentinels should be defined in Redis configuration. Set checkSentinelsList = false to avoid this check.", lastException);
            }
        }
        if (this.currentMaster.get() == null) {
            this.internalShutdown();
            throw new RedisConnectionException("Can't connect to servers!", lastException);
        }
        if (this.config.getReadMode() != ReadMode.MASTER && this.config.getSlaveAddresses().isEmpty()) {
            this.log.warn("ReadMode = {}, but slave nodes are not found!", (Object)this.config.getReadMode());
        }
        super.doConnect(disconnectedSlaves, uri2hostname::get);
        this.scheduleChangeCheck(this.cfg, null);
    }

    private static boolean isHostname(String host) {
        return NetUtil.createByteArrayFromIpAddressString((String)host) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuth(SentinelServersConfig cfg) {
        if (cfg.getPassword() == null) {
            return;
        }
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisConnection c = client.connect();
                if (this.config.getPingConnectionInterval() == 0) {
                    c.sync(RedisCommands.PING, new Object[0]);
                }
                return;
            }
            catch (RedisAuthRequiredException e) {
                this.usePassword = true;
                return;
            }
            catch (RedisConnectionException e) {
                this.log.warn("Can't connect to sentinel server", (Throwable)e);
            }
            catch (Exception exception) {}
            continue;
            finally {
                client.shutdown();
            }
        }
        this.internalShutdown();
        StringBuilder list = new StringBuilder();
        for (String address : cfg.getSentinelAddresses()) {
            list.append(address).append(", ");
        }
        throw new RedisConnectionException("Unable to connect to Redis sentinel servers: " + list);
    }

    @Override
    protected void startDNSMonitoring(RedisClient masterHost) {
        if (this.config.getDnsMonitoringInterval() == -1L || this.sentinelHosts.isEmpty()) {
            return;
        }
        this.scheduleSentinelDNSCheck();
    }

    @Override
    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig result = super.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        if (type == NodeType.SENTINEL && !this.usePassword) {
            result.setUsername(null);
            result.setPassword(null);
        } else if (type == NodeType.SENTINEL && this.usePassword) {
            result.setUsername(this.cfg.getSentinelUsername());
            if (this.cfg.getSentinelPassword() != null) {
                result.setPassword(this.cfg.getSentinelPassword());
            }
        }
        return result;
    }

    private void scheduleSentinelDNSCheck() {
        this.monitorFuture = this.serviceManager.newTimeout(t -> {
            CompletableFuture<Void> f = this.performSentinelDNSCheck();
            f.thenAccept(r -> this.scheduleSentinelDNSCheck());
        }, this.config.getDnsMonitoringInterval(), TimeUnit.MILLISECONDS);
    }

    private CompletableFuture<Void> performSentinelDNSCheck() {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (RedisURI host : this.sentinelHosts) {
            CompletableFuture<List<RedisURI>> allNodes = this.serviceManager.resolveAll(host);
            CompletionStage f = allNodes.whenComplete((nodes, ex) -> {
                if (ex != null) {
                    this.log.error("Unable to resolve {}", (Object)host.getHost(), ex);
                    return;
                }
                nodes.stream().filter(uri -> !this.sentinels.containsKey(uri) && !this.disconnectedSentinels.contains(uri)).forEach(uri -> {
                    try {
                        byte[] addr = NetUtil.createByteArrayFromIpAddressString((String)uri.getHost());
                        InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(host.getHost(), addr), uri.getPort());
                        this.registerSentinel(address);
                    }
                    catch (UnknownHostException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                });
            });
            futures.add(f);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private void scheduleChangeCheck(SentinelServersConfig cfg, Iterator<RedisClient> iterator) {
        this.monitorFuture = this.serviceManager.newTimeout(t -> {
            AtomicReference<Throwable> lastException = new AtomicReference<Throwable>();
            Iterator iter = iterator;
            if (iter == null) {
                ArrayList clients = new ArrayList(this.sentinels.values());
                Collections.shuffle(clients);
                iter = clients.iterator();
            }
            this.checkState(cfg, iter, lastException);
        }, cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkState(SentinelServersConfig cfg, Iterator<RedisClient> iterator, AtomicReference<Throwable> lastException) {
        if (!iterator.hasNext()) {
            if (lastException.get() != null) {
                this.log.error("Can't update cluster state", lastException.get());
            }
            this.disconnectedSentinels.clear();
            CompletableFuture<Void> f = this.performSentinelDNSCheck();
            f.thenAccept(r -> this.scheduleChangeCheck(cfg, null));
            return;
        }
        if (this.serviceManager.isShuttingDown()) {
            return;
        }
        RedisClient client = iterator.next();
        RedisURI addr = this.toURI(client.getAddr());
        String hostname = null;
        if (SentinelConnectionManager.isHostname(client.getAddr().getHostName())) {
            hostname = client.getAddr().getHostName();
        }
        CompletionStage<RedisConnection> connectionFuture = this.connectToNode(NodeType.SENTINEL, cfg, addr, hostname);
        connectionFuture.whenComplete((connection, e) -> {
            if (e != null) {
                lastException.set((Throwable)e);
                this.checkState(cfg, iterator, lastException);
                return;
            }
            this.updateState(cfg, (RedisConnection)connection, iterator);
        });
    }

    private void updateState(SentinelServersConfig cfg, RedisConnection connection, Iterator<RedisClient> iterator) {
        ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
        CompletionStage<RedisClient> masterFuture = this.checkMasterChange(cfg, connection);
        futures.add(masterFuture.toCompletableFuture());
        if (!this.config.isSlaveNotUsed()) {
            CompletionStage<Void> slavesFuture = this.checkSlavesChange(cfg, connection);
            futures.add(slavesFuture.toCompletableFuture());
        }
        CompletionStage<Void> sentinelsFuture = this.checkSentinelsChange(cfg, connection);
        futures.add(sentinelsFuture.toCompletableFuture());
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        future.whenComplete((r, e) -> {
            if (e != null) {
                this.log.error("Can't execute SENTINEL commands on {}", (Object)connection.getRedisClient().getAddr(), e);
            }
            if (e != null) {
                this.scheduleChangeCheck(cfg, iterator);
            } else {
                this.scheduleChangeCheck(cfg, null);
            }
        });
    }

    private CompletionStage<Void> checkSentinelsChange(SentinelServersConfig cfg, RedisConnection connection) {
        if (!cfg.isSentinelsDiscovery()) {
            return CompletableFuture.completedFuture(null);
        }
        RFuture sentinelsFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
        return sentinelsFuture.thenCompose(list -> {
            if (list.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            List<CompletableFuture> newUris = list.stream().filter(m -> {
                String flags = m.getOrDefault("flags", "");
                String masterLinkStatus = m.getOrDefault("master-link-status", "");
                return !m.isEmpty() && !this.isSlaveDown(flags, masterLinkStatus);
            }).map(m -> {
                String ip = (String)m.get("ip");
                String port = (String)m.get("port");
                CompletableFuture<InetSocketAddress> f = this.resolveIP(ip, port);
                return f.exceptionally(ex -> {
                    this.log.error("unable to resolve hostname", ex);
                    return null;
                }).toCompletableFuture();
            }).collect(Collectors.toList());
            CompletableFuture<Void> futures = CompletableFuture.allOf(newUris.toArray(new CompletableFuture[0]));
            return futures.whenComplete((r, ex) -> {
                List<InetSocketAddress> uris = newUris.stream().map(u -> {
                    try {
                        return u.getNow(null);
                    }
                    catch (Exception exc) {
                        return null;
                    }
                }).filter(u -> u != null).collect(Collectors.toList());
                InetSocketAddress addr = connection.getRedisClient().getAddr();
                uris.add(addr);
                this.updateSentinels(uris);
            });
        });
    }

    private CompletionStage<Void> checkSlavesChange(SentinelServersConfig cfg, RedisConnection connection) {
        RFuture slavesFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
        return slavesFuture.thenCompose(slavesMap -> {
            Set currentSlaves = Collections.newSetFromMap(new ConcurrentHashMap(slavesMap.size()));
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (Map map : slavesMap) {
                if (map.isEmpty()) continue;
                String host = (String)map.get("ip");
                String port = (String)map.get("port");
                String flags = map.getOrDefault("flags", "");
                String masterLinkStatus = map.getOrDefault("master-link-status", "");
                String masterHost = (String)map.get("master-host");
                String masterPort = (String)map.get("master-port");
                CompletableFuture<InetSocketAddress> slaveAddrFuture = this.resolveIP(host, port);
                CompletableFuture<Object> masterAddrFuture = "?".equals(masterHost) ? CompletableFuture.completedFuture(null) : this.resolveIP(masterHost, masterPort);
                CompletableFuture<Void> resolvedFuture = CompletableFuture.allOf(masterAddrFuture, slaveAddrFuture);
                futures.add(((CompletableFuture)resolvedFuture.whenComplete((r, exc) -> {
                    if (exc != null) {
                        this.log.error("Unable to resolve addresses {} and/or {}", new Object[]{host, masterHost, exc});
                    }
                })).thenCompose(res -> {
                    InetSocketAddress slaveAddr = slaveAddrFuture.getNow(null);
                    InetSocketAddress masterAddr = masterAddrFuture.getNow(null);
                    if (this.isSlaveDown(flags, masterLinkStatus)) {
                        this.slaveDown(slaveAddr);
                        return CompletableFuture.completedFuture(res);
                    }
                    if ("?".equals(masterHost) || !this.isUseSameMaster(slaveAddr, masterAddr)) {
                        return CompletableFuture.completedFuture(res);
                    }
                    RedisURI uri = this.toURI(slaveAddr);
                    currentSlaves.add(uri);
                    return this.addSlave(slaveAddr).whenComplete((r, e) -> {
                        if (e != null) {
                            this.log.error("Unable to add slave {}", (Object)slaveAddr, e);
                        }
                    });
                }));
            }
            CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return future.whenComplete((r, exc) -> {
                MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
                entry.getAllEntries().stream().map(e -> e.getClient().getAddr()).filter(a -> {
                    RedisURI uri = this.toURI((InetSocketAddress)a);
                    return !currentSlaves.contains(uri) && !uri.equals(this.currentMaster.get());
                }).forEach(a -> this.slaveDown((InetSocketAddress)a));
            });
        });
    }

    private CompletionStage<RedisClient> checkMasterChange(SentinelServersConfig cfg, RedisConnection connection) {
        RFuture masterFuture = connection.async(StringCodec.INSTANCE, this.masterHostCommand, cfg.getMasterName());
        return masterFuture.thenCompose(u -> this.serviceManager.resolveIP(this.scheme, (RedisURI)u)).thenCompose(newMaster -> {
            RedisURI current = this.currentMaster.get();
            if (!newMaster.equals(current) && this.currentMaster.compareAndSet(current, (RedisURI)newMaster)) {
                RedisURI h;
                RedisURI host = newMaster;
                if (newMaster.isSsl() && !(h = (RedisURI)masterFuture.toCompletableFuture().join()).isIP()) {
                    host = new RedisURI(this.scheme, h.getHost(), h.getPort());
                }
                CompletableFuture<RedisClient> changeFuture = this.changeMaster(this.singleSlotRange.getStartSlot(), host);
                return changeFuture.exceptionally(ex -> {
                    this.currentMaster.compareAndSet((RedisURI)newMaster, current);
                    return null;
                });
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private void updateSentinels(Collection<InetSocketAddress> newAddrs) {
        newAddrs.stream().filter(addr -> {
            RedisURI uri = this.toURI((InetSocketAddress)addr);
            return !this.sentinels.containsKey(uri);
        }).forEach(addr -> {
            RedisURI uri = this.toURI((InetSocketAddress)addr);
            this.disconnectedSentinels.remove(uri);
            this.registerSentinel((InetSocketAddress)addr);
        });
        this.sentinels.keySet().stream().filter(uri -> {
            for (InetSocketAddress addr : newAddrs) {
                if (!uri.equals(addr)) continue;
                return false;
            }
            return true;
        }).forEach(uri -> {
            RedisClient sentinel = (RedisClient)this.sentinels.remove(uri);
            if (sentinel != null) {
                this.disconnectNode((RedisURI)uri);
                sentinel.shutdownAsync();
                this.disconnectedSentinels.add((RedisURI)uri);
                this.log.warn("sentinel: {} is down", uri);
            }
        });
    }

    private CompletionStage<Void> registerSentinel(InetSocketAddress addr) {
        RedisURI uri = this.toURI(addr);
        RedisClient sentinel = (RedisClient)this.sentinels.get(uri);
        if (sentinel != null) {
            return CompletableFuture.completedFuture(null);
        }
        RedisURI hostname = this.serviceManager.toURI(this.scheme, addr.getAddress().getHostName(), "" + addr.getPort());
        RedisClient client = this.createClient(NodeType.SENTINEL, addr, hostname, null);
        CompletableFuture<InetSocketAddress> future = client.resolveAddr();
        return future.thenCompose(res -> {
            RedisURI ipAddr = this.toURI((InetSocketAddress)res);
            RedisClient s = (RedisClient)this.sentinels.get(ipAddr);
            if (s != null) {
                return CompletableFuture.completedFuture(null);
            }
            RFuture<RedisConnection> f = client.connectAsync();
            return f.handle((resp, e) -> {
                if (e != null) {
                    this.log.error(e.getMessage(), e);
                    throw new CompletionException((Throwable)e);
                }
                if (this.sentinels.putIfAbsent(ipAddr, client) == null) {
                    this.log.info("sentinel: {} added", (Object)ipAddr);
                } else {
                    client.shutdownAsync();
                }
                return null;
            });
        });
    }

    private CompletableFuture<InetSocketAddress> resolveIP(String host, String port) {
        RedisURI uri = this.serviceManager.toURI(this.scheme, host, port);
        return this.serviceManager.resolve(uri);
    }

    private RedisURI toURI(InetSocketAddress addr) {
        return this.serviceManager.toURI(this.scheme, addr.getAddress().getHostAddress(), "" + addr.getPort());
    }

    private CompletableFuture<Void> addSlave(InetSocketAddress addr) {
        if (this.config.isSlaveNotUsed()) {
            this.log.info("slave: {} is up", (Object)addr);
            return CompletableFuture.completedFuture(null);
        }
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        if (!entry.hasSlave(addr)) {
            RedisURI uri = this.serviceManager.toURI(this.scheme, addr.getHostName(), "" + addr.getPort());
            CompletableFuture<Void> future = entry.addSlave(addr, uri);
            return future.thenApply(res -> {
                this.log.info("slave: {} added", (Object)addr);
                return null;
            });
        }
        CompletableFuture<Boolean> f = entry.slaveUpNoMasterExclusionAsync(addr, ClientConnectionsEntry.FreezeReason.MANAGER);
        return f.thenApply(e -> {
            if (e.booleanValue()) {
                this.log.info("slave: {} is up", (Object)addr);
                entry.excludeMasterFromSlaves(addr);
            }
            return null;
        });
    }

    private void slaveDown(InetSocketAddress addr) {
        if (this.config.isSlaveNotUsed()) {
            this.log.warn("slave: {} is down", (Object)addr);
        } else {
            MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
            if (entry.slaveDown(addr, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                this.log.warn("slave: {} is down", (Object)addr);
            }
        }
    }

    private boolean isSlaveDown(String flags, String masterLinkStatus) {
        boolean baseStatus;
        boolean bl = baseStatus = flags.contains("s_down") || flags.contains("disconnected");
        if (this.cfg.isCheckSlaveStatusWithSyncing() && !StringUtil.isNullOrEmpty((String)masterLinkStatus)) {
            return baseStatus || masterLinkStatus.contains("err");
        }
        return baseStatus;
    }

    private boolean isUseSameMaster(InetSocketAddress slaveAddr, InetSocketAddress slaveMasterAddr) {
        RedisURI master = this.currentMaster.get();
        if (!master.equals(slaveMasterAddr) && !master.equals(slaveAddr)) {
            this.log.warn("Skipped slave up {} for master {} differs from current {}", new Object[]{slaveAddr, slaveMasterAddr, master});
            return false;
        }
        return true;
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        this.cfg = (SentinelServersConfig)cfg;
        if (this.cfg.getMasterName() == null) {
            throw new IllegalArgumentException("masterName parameter is not defined!");
        }
        if (this.cfg.getSentinelAddresses().isEmpty()) {
            throw new IllegalArgumentException("At least one sentinel node should be defined!");
        }
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(this.cfg.getDatabase());
        return res;
    }

    public Collection<RedisClient> getSentinels() {
        return this.sentinels.values();
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel();
        }
        this.sentinels.values().stream().map(s -> s.shutdownAsync()).forEach(f -> f.toCompletableFuture().join());
        super.shutdown(quietPeriod, timeout, unit);
    }

    private RedisURI applyNatMap(RedisURI address) {
        RedisURI result = this.cfg.getNatMapper().map(address);
        if (!result.equals(address)) {
            this.log.debug("nat mapped uri: {} to {}", (Object)address, (Object)result);
        }
        return result;
    }
}

