/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.HashedWheelTimer;
import io.netty.util.NetUtil;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.redisson.ElementsSubscribeService;
import org.redisson.Version;
import org.redisson.api.NatMapper;
import org.redisson.api.RFuture;
import org.redisson.api.StreamMessageId;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.RedisNodeNotFoundException;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.Protocol;
import org.redisson.config.TransportMode;
import org.redisson.connection.ConnectionEventsHub;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.IdleConnectionWatcher;
import org.redisson.connection.NodeSource;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.InfinitySemaphoreLatch;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Timeout DUMMY_TIMEOUT = new Timeout(){

        public Timer timer() {
            return null;
        }

        public TimerTask task() {
            return null;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean cancel() {
            return true;
        }
    };
    private final ConnectionEventsHub connectionEventsHub = new ConnectionEventsHub();
    private final String id = UUID.randomUUID().toString();
    private final EventLoopGroup group;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final ExecutorService executor;
    private final Config cfg;
    private MasterSlaveServersConfig config;
    private HashedWheelTimer timer;
    private IdleConnectionWatcher connectionWatcher;
    private final Promise<Void> shutdownPromise = ImmediateEventExecutor.INSTANCE.newPromise();
    private final InfinitySemaphoreLatch shutdownLatch = new InfinitySemaphoreLatch();
    private final ElementsSubscribeService elementsSubscribeService = new ElementsSubscribeService(this);
    private NatMapper natMapper = NatMapper.direct();
    private static final Map<InetSocketAddress, Set<String>> SCRIPT_SHA_CACHE = new ConcurrentHashMap<InetSocketAddress, Set<String>>();
    private static final Map<String, String> SHA_CACHE = new LRUCacheMap<String, String>(500, 0L, 0L);
    private final AtomicBoolean liveObjectLatch = new AtomicBoolean();

    public ServiceManager(Config cfg) {
        Version.logVersion();
        if (cfg.getTransportMode() == TransportMode.EPOLL) {
            this.group = cfg.getEventLoopGroup() == null ? new EpollEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = EpollSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(EpollDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        } else if (cfg.getTransportMode() == TransportMode.KQUEUE) {
            this.group = cfg.getEventLoopGroup() == null ? new KQueueEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = KQueueSocketChannel.class;
            this.resolverGroup = cfg.getAddressResolverGroupFactory().create(KQueueDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        } else if (cfg.getTransportMode() == TransportMode.IO_URING) {
            this.group = cfg.getEventLoopGroup() == null ? ServiceManager.createIOUringGroup(cfg) : cfg.getEventLoopGroup();
            this.socketChannelClass = IOUringSocketChannel.class;
            this.resolverGroup = cfg.getAddressResolverGroupFactory().create(IOUringDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        } else {
            this.group = cfg.getEventLoopGroup() == null ? new NioEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = NioSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(NioDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        }
        if (cfg.getExecutor() == null) {
            int threads = Runtime.getRuntime().availableProcessors() * 2;
            if (cfg.getThreads() != 0) {
                threads = cfg.getThreads();
            }
            this.executor = Executors.newFixedThreadPool(threads, (ThreadFactory)new DefaultThreadFactory("redisson"));
        } else {
            this.executor = cfg.getExecutor();
        }
        this.cfg = cfg;
        if (cfg.getConnectionListener() != null) {
            this.connectionEventsHub.addListener(cfg.getConnectionListener());
        }
        this.connectionEventsHub.addListener(new ConnectionListener(){

            @Override
            public void onConnect(InetSocketAddress addr) {
            }

            @Override
            public void onDisconnect(InetSocketAddress addr) {
                SCRIPT_SHA_CACHE.remove(addr);
            }
        });
    }

    private static EventLoopGroup createIOUringGroup(Config cfg) {
        return new IOUringEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty"));
    }

    public void initTimer() {
        int[] timeouts = new int[]{this.config.getRetryInterval(), this.config.getTimeout()};
        Arrays.sort(timeouts);
        int minTimeout = timeouts[0];
        minTimeout = minTimeout % 100 != 0 ? minTimeout % 100 / 2 : (minTimeout == 100 ? 50 : 100);
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("redisson-timer"), (long)minTimeout, TimeUnit.MILLISECONDS, 1024, false);
        this.connectionWatcher = new IdleConnectionWatcher(this.group, this.config);
    }

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        try {
            return this.timer.newTimeout(task, delay, unit);
        }
        catch (IllegalStateException e) {
            if (this.isShuttingDown()) {
                return DUMMY_TIMEOUT;
            }
            throw e;
        }
    }

    public boolean isShuttingDown() {
        return this.shutdownLatch.isClosed();
    }

    public boolean isShutdown() {
        return this.group.isTerminated();
    }

    public ConnectionEventsHub getConnectionEventsHub() {
        return this.connectionEventsHub;
    }

    public String getId() {
        return this.id;
    }

    public EventLoopGroup getGroup() {
        return this.group;
    }

    public Future<List<InetSocketAddress>> resolveAll(RedisURI uri) {
        AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)this.group.next());
        return resolver.resolveAll((SocketAddress)InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort()));
    }

    public AddressResolverGroup<InetSocketAddress> getResolverGroup() {
        return this.resolverGroup;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Config getCfg() {
        return this.cfg;
    }

    public HashedWheelTimer getTimer() {
        return this.timer;
    }

    public IdleConnectionWatcher getConnectionWatcher() {
        return this.connectionWatcher;
    }

    public Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public Promise<Void> getShutdownPromise() {
        return this.shutdownPromise;
    }

    public InfinitySemaphoreLatch getShutdownLatch() {
        return this.shutdownLatch;
    }

    public RedisNodeNotFoundException createNodeNotFoundException(NodeSource source) {
        RedisNodeNotFoundException ex = source.getSlot() != null && source.getAddr() == null && source.getRedisClient() == null ? new RedisNodeNotFoundException("Node for slot: " + source.getSlot() + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.") : new RedisNodeNotFoundException("Node: " + source + " hasn't been discovered yet. Increase value of retryAttempts and/or retryInterval settings.");
        return ex;
    }

    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    public void setConfig(MasterSlaveServersConfig config) {
        this.config = config;
    }

    public ElementsSubscribeService getElementsSubscribeService() {
        return this.elementsSubscribeService;
    }

    public CompletableFuture<RedisURI> resolveIP(RedisURI address) {
        return this.resolveIP(address.getScheme(), address);
    }

    public CompletableFuture<RedisURI> resolveIP(String scheme, RedisURI address) {
        if (address.isIP()) {
            RedisURI addr = this.toURI(scheme, address.getHost(), "" + address.getPort());
            return CompletableFuture.completedFuture(addr);
        }
        CompletableFuture<RedisURI> result = new CompletableFuture<RedisURI>();
        AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)this.group.next());
        InetSocketAddress addr = InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
        Future future = resolver.resolve((SocketAddress)addr);
        future.addListener((GenericFutureListener)((FutureListener)f -> {
            if (!f.isSuccess()) {
                this.log.error("Unable to resolve {}", (Object)address, (Object)f.cause());
                result.completeExceptionally(f.cause());
                return;
            }
            InetSocketAddress s = (InetSocketAddress)f.getNow();
            RedisURI uri = this.toURI(scheme, s.getAddress().getHostAddress(), "" + address.getPort());
            result.complete(uri);
        }));
        return result;
    }

    public CompletableFuture<InetSocketAddress> resolve(RedisURI address) {
        if (address.isIP()) {
            try {
                InetAddress ip = InetAddress.getByName(address.getHost());
                InetSocketAddress addr = new InetSocketAddress(InetAddress.getByAddress(address.getHost(), ip.getAddress()), address.getPort());
                return CompletableFuture.completedFuture(addr);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        CompletableFuture<InetSocketAddress> result = new CompletableFuture<InetSocketAddress>();
        AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)this.group.next());
        InetSocketAddress addr = InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
        Future future = resolver.resolve((SocketAddress)addr);
        future.addListener((GenericFutureListener)((FutureListener)f -> {
            if (!f.isSuccess()) {
                this.log.error("Unable to resolve {}", (Object)address, (Object)f.cause());
                result.completeExceptionally(f.cause());
                return;
            }
            InetSocketAddress s = (InetSocketAddress)f.getNow();
            result.complete(s);
        }));
        return result;
    }

    public RedisURI toURI(String scheme, String host, String port) {
        if (NetUtil.isValidIpV6Address((String)host)) {
            byte[] addr = NetUtil.createByteArrayFromIpAddressString((String)host);
            try {
                InetAddress ia = InetAddress.getByAddress(host, addr);
                host = ia.getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        RedisURI uri = new RedisURI(scheme + "://" + host + ":" + port);
        return this.natMapper.map(uri);
    }

    public void setNatMapper(NatMapper natMapper) {
        this.natMapper = natMapper;
    }

    public NatMapper getNatMapper() {
        return this.natMapper;
    }

    public boolean isCached(InetSocketAddress addr, String script) {
        Set values = SCRIPT_SHA_CACHE.computeIfAbsent(addr, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
        String sha = this.calcSHA(script);
        return values.contains(sha);
    }

    public void cacheScripts(InetSocketAddress addr, Set<String> scripts) {
        Set values = SCRIPT_SHA_CACHE.computeIfAbsent(addr, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
        for (String script : scripts) {
            values.add(this.calcSHA(script));
        }
    }

    public String calcSHA(String script) {
        return SHA_CACHE.computeIfAbsent(script, k -> {
            try {
                MessageDigest mdigest = MessageDigest.getInstance("SHA-1");
                byte[] s = mdigest.digest(script.getBytes());
                return ByteBufUtil.hexDump((byte[])s);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public <T> RFuture<T> execute(Supplier<CompletionStage<T>> supplier) {
        CompletableFuture result = new CompletableFuture();
        int retryAttempts = this.config.getRetryAttempts();
        AtomicInteger attempts = new AtomicInteger(retryAttempts);
        this.execute(attempts, result, supplier);
        return new CompletableFutureWrapper(result);
    }

    private <T> void execute(AtomicInteger attempts, CompletableFuture<T> result, Supplier<CompletionStage<T>> supplier) {
        CompletionStage<Object> future = supplier.get();
        future.whenComplete((r, e) -> {
            if (e != null) {
                if (e.getCause().getMessage().equals("None of slaves were synced")) {
                    if (attempts.decrementAndGet() < 0) {
                        result.completeExceptionally((Throwable)e);
                        return;
                    }
                    this.newTimeout(arg_0 -> this.lambda$execute$5(attempts, result, (Supplier)supplier, arg_0), this.config.getRetryInterval(), TimeUnit.MILLISECONDS);
                    return;
                }
                result.completeExceptionally((Throwable)e);
                return;
            }
            result.complete(r);
        });
    }

    public <V> void transfer(CompletionStage<V> source, CompletableFuture<V> dest) {
        source.whenComplete((res, e) -> {
            if (e != null) {
                dest.completeExceptionally((Throwable)e);
                return;
            }
            dest.complete(res);
        });
    }

    public String generateId() {
        return ByteBufUtil.hexDump((byte[])this.generateIdArray());
    }

    public byte[] generateIdArray() {
        return this.generateIdArray(16);
    }

    public byte[] generateIdArray(int size) {
        byte[] id = new byte[size];
        ThreadLocalRandom.current().nextBytes(id);
        return id;
    }

    public AtomicBoolean getLiveObjectLatch() {
        return this.liveObjectLatch;
    }

    public boolean isResp3() {
        return this.cfg.getProtocol() == Protocol.RESP3;
    }

    public RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> getXReadGroupBlockingCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREADGROUP_BLOCKING_V2;
        }
        return RedisCommands.XREADGROUP_BLOCKING;
    }

    public RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> getXReadGroupCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREADGROUP_V2;
        }
        return RedisCommands.XREADGROUP;
    }

    public RedisCommand<Map<StreamMessageId, Map<Object, Object>>> getXReadGroupBlockingSingleCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREADGROUP_BLOCKING_SINGLE_V2;
        }
        return RedisCommands.XREADGROUP_BLOCKING_SINGLE;
    }

    public RedisCommand<Map<StreamMessageId, Map<Object, Object>>> getXReadGroupSingleCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREADGROUP_SINGLE_V2;
        }
        return RedisCommands.XREADGROUP_SINGLE;
    }

    public RedisCommand<Map<StreamMessageId, Map<Object, Object>>> getXReadBlockingSingleCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREAD_BLOCKING_SINGLE_V2;
        }
        return RedisCommands.XREAD_BLOCKING_SINGLE;
    }

    public RedisCommand<Map<StreamMessageId, Map<Object, Object>>> getXReadSingleCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREAD_SINGLE_V2;
        }
        return RedisCommands.XREAD_SINGLE;
    }

    public RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> getXReadBlockingCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREAD_BLOCKING_V2;
        }
        return RedisCommands.XREAD_BLOCKING;
    }

    public RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> getXReadCommand() {
        if (this.isResp3()) {
            return RedisCommands.XREAD_V2;
        }
        return RedisCommands.XREAD;
    }

    public RedisCommand<Map<Object, Object>> getHRandomFieldCommand() {
        if (this.isResp3()) {
            return RedisCommands.HRANDFIELD_V2;
        }
        return RedisCommands.HRANDFIELD;
    }

    private /* synthetic */ void lambda$execute$5(AtomicInteger attempts, CompletableFuture result, Supplier supplier, Timeout t) throws Exception {
        this.execute(attempts, result, supplier);
    }
}

