/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.couch.profile.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ektorp.CouchDbConnector;
import org.ektorp.DocumentNotFoundException;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.service.AbstractProfileService;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.serializer.JsonSerializer;
import org.pac4j.core.util.serializer.Serializer;
import org.pac4j.couch.profile.CouchProfile;

public class CouchProfileService
extends AbstractProfileService<CouchProfile> {
    private CouchDbConnector couchDbConnector;
    private ObjectMapper objectMapper;
    private static final TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
    public static final String COUCH_ID = "_id";

    public CouchProfileService(CouchDbConnector couchDbConnector, String attributes, PasswordEncoder passwordEncoder) {
        this.setIdAttribute(COUCH_ID);
        this.objectMapper = new ObjectMapper();
        this.couchDbConnector = couchDbConnector;
        this.setAttributes(attributes);
        this.setPasswordEncoder(passwordEncoder);
    }

    public CouchProfileService() {
        this(null, null, null);
    }

    public CouchProfileService(CouchDbConnector couchDbConnector) {
        this(couchDbConnector, null, null);
    }

    public CouchProfileService(CouchDbConnector couchDbConnector, String attributes) {
        this(couchDbConnector, attributes, null);
    }

    public CouchProfileService(CouchDbConnector couchDbConnector, PasswordEncoder passwordEncoder) {
        this(couchDbConnector, null, passwordEncoder);
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"passwordEncoder", (Object)this.getPasswordEncoder());
        CommonHelper.assertNotNull((String)"couchDbConnector", (Object)this.couchDbConnector);
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new CouchProfile()));
        this.setSerializer((Serializer)new JsonSerializer(CouchProfile.class));
        super.internalInit();
    }

    protected void insert(Map<String, Object> attributes) {
        this.logger.debug("Insert doc: {}", attributes);
        this.couchDbConnector.create(attributes);
    }

    protected void update(Map<String, Object> attributes) {
        String id = (String)attributes.get(COUCH_ID);
        try {
            InputStream oldDocStream = this.couchDbConnector.getAsStream(id);
            Map res = (Map)this.objectMapper.readValue(oldDocStream, typeRef);
            res.putAll(attributes);
            this.couchDbConnector.update((Object)res);
            this.logger.debug("Updating id: {} with attributes: {}", (Object)id, attributes);
        }
        catch (DocumentNotFoundException e) {
            this.logger.debug("Insert doc (not found by update(): {}", attributes);
            this.couchDbConnector.create(attributes);
        }
        catch (IOException e) {
            this.logger.error("Unexpected IO CouchDB Exception", (Throwable)e);
        }
    }

    protected void deleteById(String id) {
        this.logger.debug("Delete id: {}", (Object)id);
        try {
            InputStream oldDocStream = this.couchDbConnector.getAsStream(id);
            JsonNode oldDoc = this.objectMapper.readTree(oldDocStream);
            String rev = oldDoc.get("_rev").asText();
            this.couchDbConnector.delete(id, rev);
        }
        catch (DocumentNotFoundException e) {
            this.logger.debug("id {} is not in the database", (Object)id);
        }
        catch (IOException e) {
            this.logger.error("Unexpected IO CouchDB Exception", (Throwable)e);
        }
    }

    private Map<String, Object> populateAttributes(Map<String, Object> rowAttributes, List<String> names) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rowAttributes.entrySet()) {
            String name = entry.getKey();
            if (names != null && !names.contains(name)) continue;
            newAttributes.put(name, entry.getValue());
        }
        return newAttributes;
    }

    protected List<Map<String, Object>> read(List<String> names, String key, String value) {
        this.logger.debug("Reading key / value: {} / {}", (Object)key, (Object)value);
        ArrayList<Map<String, Object>> listAttributes = new ArrayList<Map<String, Object>>();
        if (key.equals(COUCH_ID)) {
            try {
                InputStream oldDocStream = this.couchDbConnector.getAsStream(value);
                Map res = (Map)this.objectMapper.readValue(oldDocStream, typeRef);
                listAttributes.add(this.populateAttributes(res, names));
            }
            catch (DocumentNotFoundException e) {
                this.logger.debug("Document id {} not found", (Object)value);
            }
            catch (IOException e) {
                this.logger.error("Unexpected IO CouchDB Exception", (Throwable)e);
            }
        } else {
            ViewQuery query = new ViewQuery().designDocId("_design/pac4j").viewName("by_" + key).key(value);
            ViewResult result = this.couchDbConnector.queryView(query);
            for (ViewResult.Row row : result.getRows()) {
                String stringValue = row.getValue();
                Map res = null;
                try {
                    res = (Map)this.objectMapper.readValue(stringValue, typeRef);
                    listAttributes.add(this.populateAttributes(res, names));
                }
                catch (IOException e) {
                    this.logger.error("Unexpected IO CouchDB Exception", (Throwable)e);
                }
            }
        }
        this.logger.debug("Found: {}", listAttributes);
        return listAttributes;
    }

    public CouchDbConnector getCouchDbConnector() {
        return this.couchDbConnector;
    }

    public void setCouchDbConnector(CouchDbConnector couchDbConnector) {
        this.couchDbConnector = couchDbConnector;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"couchDbConnector", this.couchDbConnector, "passwordEncoder", this.getPasswordEncoder(), "attributes", this.getAttributes(), "profileDefinition", this.getProfileDefinition(), "idAttribute", this.getIdAttribute(), "usernameAttribute", this.getUsernameAttribute(), "passwordAttribute", this.getPasswordAttribute()});
    }
}

