/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketFactoryEx
extends SSLSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLSocketFactoryEx.class);
    private SSLContext sslCtxt;
    private String[] protocols;
    private final Settings settings;
    private static boolean protocolsLogged = false;

    public SSLSocketFactoryEx(Settings settings) throws NoSuchAlgorithmException, KeyManagementException {
        this.settings = settings;
        KeyManager[] km = this.getKeyManagers();
        TrustManager[] tm = this.getTrustManagers();
        this.initSSLSocketFactoryEx(km, tm, null);
    }

    public SSLSocketFactoryEx(KeyManager[] km, TrustManager[] tm, SecureRandom random, Settings settings) throws NoSuchAlgorithmException, KeyManagementException {
        this.settings = settings;
        this.initSSLSocketFactoryEx(km, tm, random);
    }

    public SSLSocketFactoryEx(SSLContext ctx, Settings settings) throws NoSuchAlgorithmException, KeyManagementException {
        this.settings = settings;
        this.initSSLSocketFactoryEx(ctx);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslCtxt.getSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslCtxt.getSocketFactory().getSupportedCipherSuites();
    }

    public String[] getDefaultProtocols() {
        return Arrays.copyOf(this.protocols, this.protocols.length);
    }

    public String[] getSupportedProtocols() {
        return Arrays.copyOf(this.protocols, this.protocols.length);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(s, host, port, autoClose);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(address, port, localAddress, localPort);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port, localHost, localPort);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    private void initSSLSocketFactoryEx(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslCtxt = SSLContext.getInstance("TLS");
        this.sslCtxt.init(km, tm, random);
        this.protocols = this.getProtocolList();
    }

    private void initSSLSocketFactoryEx(SSLContext ctx) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslCtxt = ctx;
        this.protocols = this.getProtocolList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getProtocolList() {
        Object[] availableProtocols;
        Socket socket = null;
        String[] preferredProtocols = this.settings.getString("downloader.tls.protocols", "TLSv1.1,TLSv1.2,TLSv1.3").split(",");
        try {
            SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
            socket = (SSLSocket)factory.createSocket();
            availableProtocols = ((SSLSocket)socket).getSupportedProtocols();
            Arrays.sort(availableProtocols);
            if (LOGGER.isDebugEnabled() && !protocolsLogged) {
                protocolsLogged = true;
                LOGGER.debug("Available Protocols:");
                for (Object p : availableProtocols) {
                    LOGGER.debug((String)p);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error getting protocol list, using TLSv1.1-1.3", (Throwable)ex);
            String[] stringArray = new String[]{"TLSv1.1", "TLSv1.2", "TLSv1.3"};
            return stringArray;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing socket", (Throwable)ex);
                }
            }
        }
        ArrayList<Object> aa = new ArrayList<Object>();
        for (String preferredProtocol : preferredProtocols) {
            int idx = Arrays.binarySearch(availableProtocols, preferredProtocol);
            if (idx < 0) continue;
            aa.add(preferredProtocol);
        }
        return aa.toArray(new String[0]);
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] km = null;
        String ksPath = System.getProperty("javax.net.ssl.keyStore");
        String ksType = System.getProperty("javax.net.ssl.keyStoreType");
        String ksPass = System.getProperty("javax.net.ssl.keyStorePassword");
        if (!(Strings.isNullOrEmpty((String)ksPath) || Strings.isNullOrEmpty((String)ksType) || Strings.isNullOrEmpty((String)ksPass))) {
            try (FileInputStream fis = new FileInputStream(ksPath);){
                KeyStore ks = KeyStore.getInstance(ksType);
                ks.load(fis, ksPass.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, ksPass.toCharArray());
                km = kmf.getKeyManagers();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                throw new RuntimeException(ex);
            }
        }
        return km;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] tm = null;
        String ksType = System.getProperty("javax.net.ssl.keyStoreType");
        String tsPath = System.getProperty("javax.net.ssl.trustStore");
        String tsPass = System.getProperty("javax.net.ssl.trustStorePassword");
        if (!(Strings.isNullOrEmpty((String)tsPath) || Strings.isNullOrEmpty((String)ksType) || Strings.isNullOrEmpty((String)tsPass))) {
            try (FileInputStream fis = new FileInputStream(tsPath);){
                KeyStore ts = KeyStore.getInstance(ksType);
                ts.load(fis, tsPass.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ts);
                tm = tmf.getTrustManagers();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new RuntimeException(ex);
            }
        }
        return tm;
    }
}

