/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuppressionRules {
    private static final SuppressionRules INSTANCE = new SuppressionRules();
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionRules.class);
    private static final List<SuppressionRule> RULES = new ArrayList<SuppressionRule>();

    private SuppressionRules() {
    }

    @SuppressFBWarnings(justification="Intended", value={"MS_EXPOSE_REP"})
    public static SuppressionRules getInstance() {
        return INSTANCE;
    }

    public int size() {
        return RULES.size();
    }

    public boolean isEmpty() {
        return RULES.isEmpty();
    }

    public List<SuppressionRule> list() {
        return RULES;
    }

    public void addAll(List<SuppressionRule> newRules) {
        RULES.addAll(newRules);
    }

    public void logUnusedRules() {
        RULES.forEach(rule -> {
            if (!rule.isMatched() && !rule.isBase()) {
                LOGGER.debug("Suppression Rule had zero matches: {}", (Object)rule.toString());
            }
        });
    }
}

