/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class RubyGemspecAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "ruby";
    private static final Logger LOGGER = LoggerFactory.getLogger(RubyGemspecAnalyzer.class);
    private static final String ANALYZER_NAME = "Ruby Gemspec Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String GEMSPEC = "gemspec";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("gemspec").build();
    private static final String VERSION_FILE_NAME = "VERSION";
    private static final Pattern GEMSPEC_BLOCK_INIT = Pattern.compile("Gem::Specification\\.new\\s+?do\\s+?\\|(.+?)\\|");

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.ruby.gemspec.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        try {
            contents = FileUtils.readFileToString((File)dependency.getActualFile(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = GEMSPEC_BLOCK_INIT.matcher(contents);
        if (matcher.find()) {
            String value;
            String description;
            String blockVariable;
            String name = this.addStringEvidence(dependency, EvidenceType.PRODUCT, contents = contents.substring(matcher.end()), blockVariable = matcher.group(1), "name", "name", Confidence.HIGHEST);
            if (!name.isEmpty()) {
                dependency.addEvidence(EvidenceType.VENDOR, GEMSPEC, "name_project", name + "_project", Confidence.LOW);
                dependency.setName(name);
            }
            if ((description = this.addStringEvidence(dependency, EvidenceType.PRODUCT, contents, blockVariable, "summary", "summary", Confidence.LOW)) != null && !description.isEmpty()) {
                dependency.setDescription(description);
            }
            this.addStringEvidence(dependency, EvidenceType.VENDOR, contents, blockVariable, "author", "authors?", Confidence.HIGHEST);
            this.addStringEvidence(dependency, EvidenceType.VENDOR, contents, blockVariable, "email", "emails?", Confidence.MEDIUM);
            this.addStringEvidence(dependency, EvidenceType.VENDOR, contents, blockVariable, "homepage", "homepage", Confidence.HIGHEST);
            String license = this.addStringEvidence(dependency, EvidenceType.VENDOR, contents, blockVariable, "license", "licen[cs]es?", Confidence.HIGHEST);
            if (license != null && !license.isEmpty()) {
                dependency.setLicense(license);
            }
            if ((value = this.addStringEvidence(dependency, EvidenceType.VERSION, contents, blockVariable, "version", "version", Confidence.HIGHEST)).length() < 1) {
                String version = this.addEvidenceFromVersionFile(dependency, EvidenceType.VERSION, dependency.getActualFile());
                if (version != null) {
                    dependency.setVersion(version);
                }
            } else {
                dependency.setVersion(value);
            }
        }
        if (dependency.getName() != null && dependency.getVersion() != null) {
            dependency.setDisplayFileName(String.format("%s:%s", dependency.getName(), dependency.getVersion()));
        }
        try {
            PackageURLBuilder builder = PackageURLBuilder.aPackageURL().withType("gem").withName(dependency.getName());
            if (dependency.getVersion() != null) {
                builder.withVersion(dependency.getVersion());
            }
            PackageURL purl = builder.build();
            dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.debug("Unable to build package url for python", (Throwable)ex);
            GenericIdentifier id = dependency.getVersion() != null ? new GenericIdentifier("gem:" + dependency.getName() + "@" + dependency.getVersion(), Confidence.HIGHEST) : new GenericIdentifier("gem:" + dependency.getName(), Confidence.HIGHEST);
            dependency.addSoftwareIdentifier(id);
        }
        this.setPackagePath(dependency);
    }

    private String addStringEvidence(Dependency dependency, EvidenceType type, String contents, String blockVariable, String field, String fieldPattern, Confidence confidence) {
        String value = "";
        Matcher arrayMatcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?\\[(.*?)\\]", blockVariable, fieldPattern), 2).matcher(contents);
        if (arrayMatcher.find()) {
            String arrayValue = arrayMatcher.group(1);
            value = arrayValue.replaceAll("['\"]", "").trim();
        } else {
            Matcher matcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?(['\"])(.*?)\\1", blockVariable, fieldPattern), 2).matcher(contents);
            if (matcher.find()) {
                value = matcher.group(2);
            }
        }
        if (value.length() > 0) {
            dependency.addEvidence(type, GEMSPEC, field, value, confidence);
        }
        return value;
    }

    private String addEvidenceFromVersionFile(Dependency dependency, EvidenceType type, File dependencyFile) {
        File parentDir = dependencyFile.getParentFile();
        String version = null;
        int versionCount = 0;
        if (parentDir != null) {
            File[] matchingFiles = parentDir.listFiles((dir, name) -> name.contains(VERSION_FILE_NAME));
            if (matchingFiles == null) {
                return null;
            }
            for (File f : matchingFiles) {
                try {
                    List lines = FileUtils.readLines((File)f, (Charset)Charset.defaultCharset());
                    if (lines.size() != 1) continue;
                    String value = ((String)lines.get(0)).trim();
                    if (version == null || !version.equals(value)) {
                        version = value;
                        ++versionCount;
                    }
                    dependency.addEvidence(type, GEMSPEC, "version", value, Confidence.HIGH);
                }
                catch (IOException e) {
                    LOGGER.debug("Error reading gemspec", (Throwable)e);
                }
            }
        }
        if (versionCount == 1) {
            return version;
        }
        return null;
    }

    private void setPackagePath(Dependency dep) {
        File file = new File(dep.getFilePath());
        String parent = file.getParent();
        if (parent != null) {
            dep.setPackagePath(parent);
        }
    }
}

