/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;

public class Dictionary {
    protected final long nativeObj;

    protected Dictionary(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Dictionary __fromPtr__(long addr) {
        return new Dictionary(addr);
    }

    public Dictionary() {
        this.nativeObj = Dictionary.Dictionary_0();
    }

    public Dictionary(Mat bytesList, int _markerSize, int maxcorr) {
        this.nativeObj = Dictionary.Dictionary_1(bytesList.nativeObj, _markerSize, maxcorr);
    }

    public Dictionary(Mat bytesList, int _markerSize) {
        this.nativeObj = Dictionary.Dictionary_2(bytesList.nativeObj, _markerSize);
    }

    public boolean identify(Mat onlyBits, int[] idx, int[] rotation, double maxCorrectionRate) {
        double[] idx_out = new double[1];
        double[] rotation_out = new double[1];
        boolean retVal = Dictionary.identify_0(this.nativeObj, onlyBits.nativeObj, idx_out, rotation_out, maxCorrectionRate);
        if (idx != null) {
            idx[0] = (int)idx_out[0];
        }
        if (rotation != null) {
            rotation[0] = (int)rotation_out[0];
        }
        return retVal;
    }

    public int getDistanceToId(Mat bits, int id, boolean allRotations) {
        return Dictionary.getDistanceToId_0(this.nativeObj, bits.nativeObj, id, allRotations);
    }

    public int getDistanceToId(Mat bits, int id) {
        return Dictionary.getDistanceToId_1(this.nativeObj, bits.nativeObj, id);
    }

    public void generateImageMarker(int id, int sidePixels, Mat _img, int borderBits) {
        Dictionary.generateImageMarker_0(this.nativeObj, id, sidePixels, _img.nativeObj, borderBits);
    }

    public void generateImageMarker(int id, int sidePixels, Mat _img) {
        Dictionary.generateImageMarker_1(this.nativeObj, id, sidePixels, _img.nativeObj);
    }

    public static Mat getByteListFromBits(Mat bits) {
        return new Mat(Dictionary.getByteListFromBits_0(bits.nativeObj));
    }

    public static Mat getBitsFromByteList(Mat byteList, int markerSize) {
        return new Mat(Dictionary.getBitsFromByteList_0(byteList.nativeObj, markerSize));
    }

    public Mat get_bytesList() {
        return new Mat(Dictionary.get_bytesList_0(this.nativeObj));
    }

    public void set_bytesList(Mat bytesList) {
        Dictionary.set_bytesList_0(this.nativeObj, bytesList.nativeObj);
    }

    public int get_markerSize() {
        return Dictionary.get_markerSize_0(this.nativeObj);
    }

    public void set_markerSize(int markerSize) {
        Dictionary.set_markerSize_0(this.nativeObj, markerSize);
    }

    public int get_maxCorrectionBits() {
        return Dictionary.get_maxCorrectionBits_0(this.nativeObj);
    }

    public void set_maxCorrectionBits(int maxCorrectionBits) {
        Dictionary.set_maxCorrectionBits_0(this.nativeObj, maxCorrectionBits);
    }

    protected void finalize() throws Throwable {
        Dictionary.delete(this.nativeObj);
    }

    private static native long Dictionary_0();

    private static native long Dictionary_1(long var0, int var2, int var3);

    private static native long Dictionary_2(long var0, int var2);

    private static native boolean identify_0(long var0, long var2, double[] var4, double[] var5, double var6);

    private static native int getDistanceToId_0(long var0, long var2, int var4, boolean var5);

    private static native int getDistanceToId_1(long var0, long var2, int var4);

    private static native void generateImageMarker_0(long var0, int var2, int var3, long var4, int var6);

    private static native void generateImageMarker_1(long var0, int var2, int var3, long var4);

    private static native long getByteListFromBits_0(long var0);

    private static native long getBitsFromByteList_0(long var0, int var2);

    private static native long get_bytesList_0(long var0);

    private static native void set_bytesList_0(long var0, long var2);

    private static native int get_markerSize_0(long var0);

    private static native void set_markerSize_0(long var0, int var2);

    private static native int get_maxCorrectionBits_0(long var0);

    private static native void set_maxCorrectionBits_0(long var0, int var2);

    private static native void delete(long var0);
}

